/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.AndCondition;
import org.springframework.data.relational.core.sql.OrCondition;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.FilteredSingleConditionRenderSupport;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;

class MultiConcatConditionVisitor
extends FilteredSingleConditionRenderSupport {
    private final RenderTarget target;
    private final String concat;
    private final StringBuilder part = new StringBuilder();

    MultiConcatConditionVisitor(RenderContext context, AndCondition condition, RenderTarget target) {
        super(context, it -> it == condition);
        this.target = target;
        this.concat = " AND ";
    }

    MultiConcatConditionVisitor(RenderContext context, OrCondition condition, RenderTarget target) {
        super(context, it -> it == condition);
        this.target = target;
        this.concat = " OR ";
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.hasDelegatedRendering()) {
            if (this.part.length() != 0) {
                this.part.append(this.concat);
            }
            this.part.append(this.consumeRenderedPart());
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Visitable segment) {
        this.target.onRendered(this.part);
        return super.leaveMatched(segment);
    }
}

