/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.domain.Sort;

public interface OrderByNullPrecedence {
    public static final OrderByNullPrecedence SQL_STANDARD = new SqlStandardOrderByNullPrecedence();
    public static final OrderByNullPrecedence NONE = nullHandling -> "";

    public String evaluate(Sort.NullHandling var1);

    public static class SqlStandardOrderByNullPrecedence
    implements OrderByNullPrecedence {
        private static final String NULLS_FIRST = "NULLS FIRST";
        private static final String NULLS_LAST = "NULLS LAST";
        private static final String UNSPECIFIED = "";

        @Override
        public String evaluate(Sort.NullHandling nullHandling) {
            switch (nullHandling) {
                case NULLS_FIRST: {
                    return NULLS_FIRST;
                }
                case NULLS_LAST: {
                    return NULLS_LAST;
                }
                case NATIVE: {
                    return UNSPECIFIED;
                }
            }
            throw new UnsupportedOperationException("Sort.NullHandling " + String.valueOf(nullHandling) + " not supported");
        }
    }
}

