/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.UnaryOperator;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DerivedSqlIdentifier
implements SqlIdentifier {
    private final String name;
    private final boolean quoted;
    private final String toString;
    @Nullable
    private volatile CachedSqlName sqlName;

    DerivedSqlIdentifier(String name, boolean quoted) {
        Assert.hasText((String)name, (String)"A database object must have at least on name part.");
        this.name = name;
        this.quoted = quoted;
        this.toString = quoted ? this.toSql(IdentifierProcessing.ANSI) : this.name;
    }

    public Iterator<SqlIdentifier> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    public SqlIdentifier transform(UnaryOperator<String> transformationFunction) {
        Assert.notNull(transformationFunction, (String)"Transformation function must not be null");
        return new DerivedSqlIdentifier((String)transformationFunction.apply(this.name), this.quoted);
    }

    @Override
    public String toSql(IdentifierProcessing processing) {
        CachedSqlName sqlName = this.sqlName;
        if (sqlName == null || sqlName.processing != processing) {
            String normalized = processing.standardizeLetterCase(this.name);
            this.sqlName = sqlName = new CachedSqlName(processing, this.quoted ? processing.quote(normalized) : normalized);
            return sqlName.sqlName();
        }
        return sqlName.sqlName();
    }

    @Override
    @Deprecated(since="3.1", forRemoval=true)
    public String getReference(IdentifierProcessing processing) {
        return this.name;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SqlIdentifier) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.toString;
    }

    record CachedSqlName(IdentifierProcessing processing, String sqlName) {
    }
}

