/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Objects;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated(since="3.2", forRemoval=true)
public class PersistentPropertyPathExtension {
    private final RelationalPersistentEntity<?> entity;
    @Nullable
    private final PersistentPropertyPath<? extends RelationalPersistentProperty> path;
    private final MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context;
    private final Lazy<SqlIdentifier> columnAlias = Lazy.of(() -> this.prefixWithTableAlias(this.getColumnName()));

    public PersistentPropertyPathExtension(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, RelationalPersistentEntity<?> entity) {
        Assert.notNull(context, (String)"Context must not be null");
        Assert.notNull(entity, (String)"Entity must not be null");
        this.context = context;
        this.entity = entity;
        this.path = null;
    }

    public PersistentPropertyPathExtension(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        Assert.notNull(context, (String)"Context must not be null");
        Assert.notNull(path, (String)"Path must not be null");
        Assert.notNull((Object)path.getBaseProperty(), (String)"Path must not be empty.");
        this.context = context;
        this.entity = ((RelationalPersistentProperty)path.getBaseProperty()).getOwner();
        this.path = path;
    }

    public static boolean isWritable(@Nullable PersistentPropertyPath<? extends RelationalPersistentProperty> path) {
        return path == null || ((RelationalPersistentProperty)path.getLeafProperty()).isWritable() && PersistentPropertyPathExtension.isWritable((PersistentPropertyPath<? extends RelationalPersistentProperty>)path.getParentPath());
    }

    public boolean isEmbedded() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getLeafProperty()).isEmbedded();
    }

    public PersistentPropertyPathExtension getParentPath() {
        if (this.path == null) {
            throw new IllegalStateException("The parent path of a root path is not defined.");
        }
        if (this.path.getLength() == 1) {
            return new PersistentPropertyPathExtension(this.context, this.entity);
        }
        return new PersistentPropertyPathExtension(this.context, (PersistentPropertyPath<? extends RelationalPersistentProperty>)this.path.getParentPath());
    }

    public boolean isMultiValued() {
        return this.path != null && (((RelationalPersistentProperty)this.path.getLeafProperty()).isCollectionLike() || ((RelationalPersistentProperty)this.path.getLeafProperty()).isQualified() || this.getParentPath().isMultiValued());
    }

    @Nullable
    public RelationalPersistentEntity<?> getLeafEntity() {
        return this.path == null ? this.entity : (RelationalPersistentEntity)this.context.getPersistentEntity(((RelationalPersistentProperty)this.path.getLeafProperty()).getActualType());
    }

    public RelationalPersistentEntity<?> getRequiredLeafEntity() {
        RelationalPersistentEntity<?> entity = this.getLeafEntity();
        if (entity == null) {
            if (this.path == null) {
                throw new IllegalStateException("Couldn't resolve leaf PersistentEntity absent path");
            }
            throw new IllegalStateException(String.format("Couldn't resolve leaf PersistentEntity for type %s", ((RelationalPersistentProperty)this.path.getLeafProperty()).getActualType()));
        }
        return entity;
    }

    public boolean isEntity() {
        return this.path == null || ((RelationalPersistentProperty)this.path.getLeafProperty()).isEntity();
    }

    public boolean isQualified() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getLeafProperty()).isQualified();
    }

    public boolean isCollectionLike() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getLeafProperty()).isCollectionLike();
    }

    public SqlIdentifier getReverseColumnName() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Empty paths don't have a reverse column name");
        return ((RelationalPersistentProperty)this.path.getLeafProperty()).getReverseColumnName(this);
    }

    public SqlIdentifier getReverseColumnNameAlias() {
        return this.prefixWithTableAlias(this.getReverseColumnName());
    }

    public SqlIdentifier getColumnName() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        return ((RelationalPersistentProperty)this.path.getLeafProperty()).getColumnName();
    }

    public SqlIdentifier getColumnAlias() {
        return (SqlIdentifier)this.columnAlias.get();
    }

    public boolean hasIdProperty() {
        RelationalPersistentEntity<?> leafEntity = this.getLeafEntity();
        return leafEntity != null && leafEntity.hasIdProperty();
    }

    public PersistentPropertyPathExtension getIdDefiningParentPath() {
        PersistentPropertyPathExtension parent = this.getParentPath();
        if (parent.path == null) {
            return parent;
        }
        if (!parent.hasIdProperty()) {
            return parent.getIdDefiningParentPath();
        }
        return parent;
    }

    public SqlIdentifier getQualifiedTableName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getQualifiedTableName();
    }

    public SqlIdentifier getTableName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getTableName();
    }

    @Nullable
    public SqlIdentifier getTableAlias() {
        PersistentPropertyPathExtension tableOwner = this.getTableOwningAncestor();
        return tableOwner.path == null ? null : tableOwner.assembleTableAlias();
    }

    public SqlIdentifier getIdColumnName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getIdColumn();
    }

    public SqlIdentifier getEffectiveIdColumnName() {
        PersistentPropertyPathExtension owner = this.getTableOwningAncestor();
        return owner.path == null ? owner.getRequiredLeafEntity().getIdColumn() : owner.getReverseColumnName();
    }

    public int getLength() {
        return this.path == null ? 0 : this.path.getLength();
    }

    public boolean matches(PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.path == null ? path.isEmpty() : this.path.equals(path);
    }

    public RelationalPersistentProperty getRequiredIdProperty() {
        return this.path == null ? (RelationalPersistentProperty)this.entity.getRequiredIdProperty() : (RelationalPersistentProperty)this.getRequiredLeafEntity().getRequiredIdProperty();
    }

    @Nullable
    public SqlIdentifier getQualifierColumn() {
        return this.path == null ? SqlIdentifier.EMPTY : ((RelationalPersistentProperty)this.path.getLeafProperty()).getKeyColumn();
    }

    @Nullable
    public Class<?> getQualifierColumnType() {
        return this.path == null ? null : ((RelationalPersistentProperty)this.path.getLeafProperty()).getQualifierColumnType();
    }

    public PersistentPropertyPathExtension extendBy(RelationalPersistentProperty property) {
        PersistentPropertyPath newPath = this.path == null ? this.context.getPersistentPropertyPath(property.getName(), this.entity.getType()) : this.context.getPersistentPropertyPath(this.path.toDotPath() + "." + property.getName(), this.entity.getType());
        return new PersistentPropertyPathExtension(this.context, (PersistentPropertyPath<? extends RelationalPersistentProperty>)newPath);
    }

    public String toString() {
        return String.format("PersistentPropertyPathExtension[%s, %s]", this.entity.getName(), this.path == null ? "-" : this.path.toDotPath());
    }

    public Class<?> getActualType() {
        return this.path == null ? this.entity.getType() : ((RelationalPersistentProperty)this.path.getLeafProperty()).getActualType();
    }

    public boolean isMap() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getLeafProperty()).isMap();
    }

    public PersistentPropertyPath<? extends RelationalPersistentProperty> getRequiredPersistentPropertyPath() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"No path.");
        return this.path;
    }

    private PersistentPropertyPathExtension getTableOwningAncestor() {
        return this.isEntity() && !this.isEmbedded() ? this : this.getParentPath().getTableOwningAncestor();
    }

    @Nullable
    private SqlIdentifier assembleTableAlias() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        RelationalPersistentProperty leafProperty = (RelationalPersistentProperty)this.path.getLeafProperty();
        String prefix = this.isEmbedded() ? leafProperty.getEmbeddedPrefix() : leafProperty.getName();
        if (this.path.getLength() == 1) {
            Assert.notNull((Object)prefix, (String)"Prefix mus not be null");
            return StringUtils.hasText((String)prefix) ? SqlIdentifier.quoted(prefix) : null;
        }
        PersistentPropertyPathExtension parentPath = this.getParentPath();
        SqlIdentifier sqlIdentifier = parentPath.assembleTableAlias();
        if (sqlIdentifier != null) {
            return parentPath.isEmbedded() ? sqlIdentifier.transform(name -> name.concat(prefix)) : sqlIdentifier.transform(name -> name + "_" + prefix);
        }
        return SqlIdentifier.quoted(prefix);
    }

    private SqlIdentifier prefixWithTableAlias(SqlIdentifier columnName) {
        SqlIdentifier tableAlias = this.getTableAlias();
        return tableAlias == null ? columnName : columnName.transform(name -> tableAlias.getReference() + "_" + name);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentPropertyPathExtension that = (PersistentPropertyPathExtension)o;
        return this.entity.equals(that.entity) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.path);
    }

    public AggregatePath getAggregatePath() {
        if (this.path != null) {
            return ((RelationalMappingContext)this.context).getAggregatePath(this.path);
        }
        return ((RelationalMappingContext)this.context).getAggregatePath(this.entity);
    }
}

