/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Optional;
import java.util.Set;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.DerivedSqlIdentifier;
import org.springframework.data.relational.core.mapping.Embedded;
import org.springframework.data.relational.core.mapping.MappedCollection;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Optionals;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicRelationalPersistentProperty
extends AnnotationBasedPersistentProperty<RelationalPersistentProperty>
implements RelationalPersistentProperty {
    private final Lazy<SqlIdentifier> columnName;
    private final Lazy<Optional<SqlIdentifier>> collectionIdColumnName;
    private final Lazy<SqlIdentifier> collectionKeyColumnName;
    private final Lazy<Boolean> isEmbedded;
    private final Lazy<String> embeddedPrefix;
    private final NamingStrategy namingStrategy;
    private boolean forceQuote = true;

    @Deprecated
    public BasicRelationalPersistentProperty(Property property, PersistentEntity<?, RelationalPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, RelationalMappingContext context) {
        this(property, owner, simpleTypeHolder, context.getNamingStrategy());
    }

    public BasicRelationalPersistentProperty(Property property, PersistentEntity<?, RelationalPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, NamingStrategy namingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.namingStrategy = namingStrategy;
        Assert.notNull((Object)namingStrategy, (String)"NamingStrategy must not be null.");
        this.isEmbedded = Lazy.of(() -> Optional.ofNullable((Embedded)this.findAnnotation(Embedded.class)).isPresent());
        this.embeddedPrefix = Lazy.of(() -> Optional.ofNullable((Embedded)this.findAnnotation(Embedded.class)).map(Embedded::prefix).orElse(""));
        this.columnName = Lazy.of(() -> Optional.ofNullable((Column)this.findAnnotation(Column.class)).map(Column::value).filter(StringUtils::hasText).map(this::createSqlIdentifier).orElseGet(() -> this.createDerivedSqlIdentifier(namingStrategy.getColumnName(this))));
        this.collectionIdColumnName = Lazy.of(() -> Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable((MappedCollection)this.findAnnotation(MappedCollection.class)).map(MappedCollection::idColumn), Optional.ofNullable((Column)this.findAnnotation(Column.class)).map(Column::value)}).filter(StringUtils::hasText).findFirst().map(this::createSqlIdentifier));
        this.collectionKeyColumnName = Lazy.of(() -> Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable((MappedCollection)this.findAnnotation(MappedCollection.class)).map(MappedCollection::keyColumn)}).filter(StringUtils::hasText).findFirst().map(this::createSqlIdentifier).orElseGet(() -> this.createDerivedSqlIdentifier(namingStrategy.getKeyColumn(this))));
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted(name) : SqlIdentifier.unquoted(name);
    }

    private SqlIdentifier createDerivedSqlIdentifier(String name) {
        return new DerivedSqlIdentifier(name, this.isForceQuote());
    }

    protected Association<RelationalPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    public boolean isEntity() {
        return super.isEntity() && !this.isAssociation();
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public SqlIdentifier getColumnName() {
        return (SqlIdentifier)this.columnName.get();
    }

    @Override
    public RelationalPersistentEntity<?> getOwner() {
        return (RelationalPersistentEntity)super.getOwner();
    }

    @Override
    public SqlIdentifier getReverseColumnName(PersistentPropertyPathExtension path) {
        return ((Optional)this.collectionIdColumnName.get()).orElseGet(() -> this.createDerivedSqlIdentifier(this.namingStrategy.getReverseColumnName(path)));
    }

    @Override
    public SqlIdentifier getKeyColumn() {
        return this.isQualified() ? (SqlIdentifier)this.collectionKeyColumnName.get() : null;
    }

    @Override
    public boolean isQualified() {
        return this.isMap() || this.isListLike();
    }

    @Override
    public Class<?> getQualifierColumnType() {
        Assert.isTrue((boolean)this.isQualified(), (String)"The qualifier column type is only defined for properties that are qualified");
        if (this.isMap()) {
            return this.getTypeInformation().getRequiredComponentType().getType();
        }
        return Integer.class;
    }

    @Override
    public boolean isOrdered() {
        return this.isListLike();
    }

    @Override
    public boolean isEmbedded() {
        return (Boolean)this.isEmbedded.get();
    }

    @Override
    public String getEmbeddedPrefix() {
        return this.isEmbedded() ? (String)this.embeddedPrefix.get() : null;
    }

    @Override
    public boolean shouldCreateEmptyEmbedded() {
        Embedded findAnnotation = (Embedded)this.findAnnotation(Embedded.class);
        return findAnnotation != null && Embedded.OnEmpty.USE_EMPTY.equals((Object)findAnnotation.onEmpty());
    }

    private boolean isListLike() {
        return this.isCollectionLike() && !Set.class.isAssignableFrom(this.getType());
    }
}

