/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.IdValueSource;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.Pair;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface DbAction<T> {
    public Class<T> getEntityType();

    public static interface WithPropertyPath<T>
    extends DbAction<T> {
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath();

        @Override
        default public Class<T> getEntityType() {
            return ((RelationalPersistentProperty)this.getPropertyPath().getRequiredLeafProperty()).getActualType();
        }
    }

    public static interface WithGeneratedId<T>
    extends WithEntity<T> {
        @Override
        default public Class<T> getEntityType() {
            return this.getEntity().getClass();
        }
    }

    public static interface WithEntity<T>
    extends DbAction<T> {
        public T getEntity();

        @Override
        default public Class<T> getEntityType() {
            return this.getEntity().getClass();
        }
    }

    public static interface WithDependingOn<T>
    extends WithPropertyPath<T>,
    WithEntity<T> {
        public WithEntity<?> getDependingOn();

        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers();

        @Nullable
        default public Pair<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifier() {
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = this.getQualifiers();
            if (qualifiers.size() == 0) {
                return null;
            }
            if (qualifiers.size() > 1) {
                throw new IllegalStateException("Can't handle more then one qualifier");
            }
            Map.Entry<PersistentPropertyPath<RelationalPersistentProperty>, Object> entry = qualifiers.entrySet().iterator().next();
            if (entry.getValue() == null) {
                return null;
            }
            return Pair.of(entry.getKey(), (Object)entry.getValue());
        }

        @Override
        default public Class<T> getEntityType() {
            return WithEntity.super.getEntityType();
        }
    }

    public static final class InsertBatch<T>
    implements DbAction<T> {
        private final List<Insert<T>> inserts;
        private final IdValueSource idValueSource;

        public InsertBatch(List<Insert<T>> inserts, IdValueSource idValueSource) {
            Assert.notEmpty(inserts, (String)"Inserts must contains at least one insert");
            this.inserts = inserts;
            this.idValueSource = idValueSource;
        }

        @Override
        public Class<T> getEntityType() {
            return this.inserts.get(0).getEntityType();
        }

        public List<Insert<T>> getInserts() {
            return this.inserts;
        }

        public IdValueSource getIdValueSource() {
            return this.idValueSource;
        }

        public String toString() {
            return "InsertBatch{inserts=" + this.inserts + ", idValueSource=" + this.idValueSource + "}";
        }
    }

    public static final class AcquireLockAllRoot<T>
    implements DbAction<T> {
        private final Class<T> entityType;

        AcquireLockAllRoot(Class<T> entityType) {
            this.entityType = entityType;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.AcquireLockAllRoot(entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class AcquireLockRoot<T>
    implements DbAction<T> {
        private final Object id;
        private final Class<T> entityType;

        AcquireLockRoot(Object id, Class<T> entityType) {
            this.id = id;
            this.entityType = entityType;
        }

        public Object getId() {
            return this.id;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.AcquireLockRoot(id=" + this.getId() + ", entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class DeleteAllRoot<T>
    implements DbAction<T> {
        private final Class<T> entityType;

        public DeleteAllRoot(Class<T> entityType) {
            this.entityType = entityType;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public String toString() {
            return "DbAction.DeleteAllRoot(entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class DeleteAll<T>
    implements WithPropertyPath<T> {
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        public DeleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            this.propertyPath = propertyPath;
        }

        @Override
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public String toString() {
            return "DbAction.DeleteAll(propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static final class DeleteRoot<T>
    implements DbAction<T> {
        private final Object id;
        private final Class<T> entityType;
        @Nullable
        private final Number previousVersion;

        public DeleteRoot(Object id, Class<T> entityType, @Nullable Number previousVersion) {
            this.id = id;
            this.entityType = entityType;
            this.previousVersion = previousVersion;
        }

        public Object getId() {
            return this.id;
        }

        @Override
        public Class<T> getEntityType() {
            return this.entityType;
        }

        @Nullable
        public Number getPreviousVersion() {
            return this.previousVersion;
        }

        public String toString() {
            return "DbAction.DeleteRoot(id=" + this.getId() + ", entityType=" + this.getEntityType() + ", previousVersion=" + this.getPreviousVersion() + ")";
        }
    }

    public static final class Delete<T>
    implements WithPropertyPath<T> {
        private final Object rootId;
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        public Delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            this.rootId = rootId;
            this.propertyPath = propertyPath;
        }

        public Object getRootId() {
            return this.rootId;
        }

        @Override
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public String toString() {
            return "DbAction.Delete(rootId=" + this.getRootId() + ", propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static class UpdateRoot<T>
    implements WithEntity<T> {
        private final T entity;

        public UpdateRoot(T entity) {
            this.entity = entity;
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        public String toString() {
            return "DbAction.UpdateRoot(entity=" + this.getEntity() + ")";
        }
    }

    public static final class Update<T>
    implements WithEntity<T> {
        private final T entity;
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        public Update(T entity, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            this.entity = entity;
            this.propertyPath = propertyPath;
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public String toString() {
            return "DbAction.Update(entity=" + this.getEntity() + ", propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static class InsertRoot<T>
    implements WithGeneratedId<T> {
        private final T entity;
        private final IdValueSource idValueSource;

        public InsertRoot(T entity, IdValueSource idValueSource) {
            this.entity = entity;
            this.idValueSource = idValueSource;
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        public IdValueSource getIdValueSource() {
            return this.idValueSource;
        }

        public String toString() {
            return "InsertRoot{entity=" + this.entity + ", idValueSource=" + this.idValueSource + "}";
        }
    }

    public static class Insert<T>
    implements WithGeneratedId<T>,
    WithDependingOn<T> {
        private final T entity;
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;
        private final WithEntity<?> dependingOn;
        private final IdValueSource idValueSource;
        final Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers;

        public Insert(T entity, PersistentPropertyPath<RelationalPersistentProperty> propertyPath, WithEntity<?> dependingOn, Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers, IdValueSource idValueSource) {
            this.entity = entity;
            this.propertyPath = propertyPath;
            this.dependingOn = dependingOn;
            this.qualifiers = Collections.unmodifiableMap(new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object>(qualifiers));
            this.idValueSource = idValueSource;
        }

        @Override
        public Class<T> getEntityType() {
            return WithDependingOn.super.getEntityType();
        }

        @Override
        public T getEntity() {
            return this.entity;
        }

        @Override
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        public WithEntity<?> getDependingOn() {
            return this.dependingOn;
        }

        @Override
        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers() {
            return this.qualifiers;
        }

        public IdValueSource getIdValueSource() {
            return this.idValueSource;
        }

        public String toString() {
            return "Insert{entity=" + this.entity + ", propertyPath=" + this.propertyPath + ", dependingOn=" + this.dependingOn + ", idValueSource=" + this.idValueSource + ", qualifiers=" + this.qualifiers + "}";
        }
    }
}

