/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.auditing;

import org.springframework.core.Ordered;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.relational.core.mapping.event.BeforeConvertCallback;
import org.springframework.util.Assert;

public class RelationalAuditingCallback
implements BeforeConvertCallback<Object>,
Ordered {
    public static final int AUDITING_ORDER = 100;
    private final IsNewAwareAuditingHandler handler;

    public RelationalAuditingCallback(IsNewAwareAuditingHandler handler) {
        Assert.notNull((Object)handler, (String)"Handler must not be null;");
        this.handler = handler;
    }

    public int getOrder() {
        return 100;
    }

    @Override
    public Object onBeforeConvert(Object entity) {
        return this.handler.markAudited(entity);
    }
}

