/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.DefaultIdentifierProcessing;

public interface IdentifierProcessing {
    public static final IdentifierProcessing ANSI = IdentifierProcessing.create(Quoting.ANSI, LetterCasing.UPPER_CASE);
    public static final IdentifierProcessing NONE = IdentifierProcessing.create(Quoting.NONE, LetterCasing.AS_IS);

    public static DefaultIdentifierProcessing create(Quoting quoting, LetterCasing letterCasing) {
        return new DefaultIdentifierProcessing(quoting, letterCasing);
    }

    public String quote(String var1);

    public String standardizeLetterCase(String var1);

    public static enum LetterCasing {
        UPPER_CASE{

            @Override
            public String apply(String identifier) {
                return identifier.toUpperCase();
            }
        }
        ,
        LOWER_CASE{

            @Override
            public String apply(String identifier) {
                return identifier.toLowerCase();
            }
        }
        ,
        AS_IS{

            @Override
            public String apply(String identifier) {
                return identifier;
            }
        };


        abstract String apply(String var1);
    }

    public static class Quoting {
        public static final Quoting ANSI = new Quoting("\"");
        public static final Quoting NONE = new Quoting("");
        private final String prefix;
        private final String suffix;

        public Quoting(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public Quoting(String quoteCharacter) {
            this(quoteCharacter, quoteCharacter);
        }

        public String apply(String identifier) {
            return this.prefix + identifier + this.suffix;
        }
    }
}

