/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Between;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.Like;
import org.springframework.data.relational.core.sql.NestedCondition;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SubselectExpression;
import org.springframework.util.Assert;

public abstract class Conditions {
    public static Condition just(String sql) {
        return new ConstantCondition(sql);
    }

    public static Condition nest(Condition condition) {
        return new NestedCondition(condition);
    }

    public static IsNull isNull(Expression expression) {
        return IsNull.create(expression);
    }

    public static Comparison isEqual(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Comparison.create(leftColumnOrExpression, "=", rightColumnOrExpression);
    }

    public static Comparison isNotEqual(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Comparison.create(leftColumnOrExpression, "!=", rightColumnOrExpression);
    }

    public static Between between(Expression columnOrExpression, Expression begin, Expression end) {
        return Between.create(columnOrExpression, begin, end);
    }

    public static Between notBetween(Expression columnOrExpression, Expression begin, Expression end) {
        return Conditions.between(columnOrExpression, begin, end).not();
    }

    public static Comparison isLess(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Comparison.create(leftColumnOrExpression, "<", rightColumnOrExpression);
    }

    public static Comparison isLessOrEqualTo(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Comparison.create(leftColumnOrExpression, "<=", rightColumnOrExpression);
    }

    public static Comparison isGreater(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Comparison.create(leftColumnOrExpression, ">", rightColumnOrExpression);
    }

    public static Comparison isGreaterOrEqualTo(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Comparison.create(leftColumnOrExpression, ">=", rightColumnOrExpression);
    }

    public static Like like(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Like.create(leftColumnOrExpression, rightColumnOrExpression);
    }

    public static Like notLike(Expression leftColumnOrExpression, Expression rightColumnOrExpression) {
        return Like.create(leftColumnOrExpression, rightColumnOrExpression).not();
    }

    public static In in(Expression columnOrExpression, Expression arg) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)arg, (String)"Expression argument must not be null");
        return In.create(columnOrExpression, arg);
    }

    public static Condition in(Expression columnOrExpression, Collection<? extends Expression> expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull(expressions, (String)"Expression argument must not be null");
        return In.create(columnOrExpression, new ArrayList<Expression>(expressions));
    }

    public static In in(Expression columnOrExpression, Expression ... expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)expressions, (String)"Expression argument must not be null");
        return In.create(columnOrExpression, Arrays.asList(expressions));
    }

    public static In in(Column column, Select subselect) {
        Assert.notNull((Object)column, (String)"Column must not be null");
        Assert.notNull((Object)subselect, (String)"Subselect must not be null");
        return Conditions.in((Expression)column, (Expression)new SubselectExpression(subselect));
    }

    public static In notIn(Expression columnOrExpression, Expression arg) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)arg, (String)"Expression argument must not be null");
        return In.create(columnOrExpression, arg);
    }

    public static Condition notIn(Expression columnOrExpression, Collection<? extends Expression> expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull(expressions, (String)"Expression argument must not be null");
        return In.createNotIn(columnOrExpression, new ArrayList<Expression>(expressions));
    }

    public static In notIn(Expression columnOrExpression, Expression ... expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)expressions, (String)"Expression argument must not be null");
        return In.createNotIn(columnOrExpression, Arrays.asList(expressions));
    }

    public static In notIn(Column column, Select subselect) {
        Assert.notNull((Object)column, (String)"Column must not be null");
        Assert.notNull((Object)subselect, (String)"Subselect must not be null");
        return Conditions.notIn((Expression)column, (Expression)new SubselectExpression(subselect));
    }

    private Conditions() {
    }

    static class ConstantCondition
    extends AbstractSegment
    implements Condition {
        private final String condition;

        ConstantCondition(String condition) {
            super(new Segment[0]);
            this.condition = condition;
        }

        @Override
        public String toString() {
            return this.condition;
        }
    }
}

