/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RelationalEntityDeleteWriter
implements EntityWriter<Object, MutableAggregateChange<?>> {
    private final RelationalMappingContext context;

    public RelationalEntityDeleteWriter(RelationalMappingContext context) {
        Assert.notNull((Object)((Object)context), (String)"Context must not be null");
        this.context = context;
    }

    public void write(@Nullable Object id, MutableAggregateChange<?> aggregateChange) {
        if (id == null) {
            this.deleteAll(aggregateChange.getEntityType()).forEach(aggregateChange::addAction);
        } else {
            this.deleteRoot(id, aggregateChange).forEach(aggregateChange::addAction);
        }
    }

    private List<DbAction<?>> deleteAll(Class<?> entityType) {
        ArrayList actions = new ArrayList();
        this.context.findPersistentPropertyPaths(entityType, PersistentProperty::isEntity).filter(p -> !((RelationalPersistentProperty)p.getRequiredLeafProperty()).isEmbedded()).forEach(p -> actions.add(new DbAction.DeleteAll((PersistentPropertyPath<RelationalPersistentProperty>)p)));
        Collections.reverse(actions);
        DbAction.DeleteAllRoot result = new DbAction.DeleteAllRoot(entityType);
        actions.add(result);
        return actions;
    }

    private <T> List<DbAction<?>> deleteRoot(Object id, AggregateChange<T> aggregateChange) {
        ArrayList actions = new ArrayList(this.deleteReferencedEntities(id, aggregateChange));
        actions.add(new DbAction.DeleteRoot<T>(id, aggregateChange.getEntityType(), this.getVersion(aggregateChange)));
        return actions;
    }

    private List<DbAction<?>> deleteReferencedEntities(Object id, AggregateChange<?> aggregateChange) {
        ArrayList actions = new ArrayList();
        this.context.findPersistentPropertyPaths(aggregateChange.getEntityType(), PersistentProperty::isEntity).filter(p -> !((RelationalPersistentProperty)p.getRequiredLeafProperty()).isEmbedded()).forEach(p -> actions.add(new DbAction.Delete(id, (PersistentPropertyPath<RelationalPersistentProperty>)p)));
        Collections.reverse(actions);
        return actions;
    }

    @Nullable
    private Number getVersion(AggregateChange<?> aggregateChange) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(aggregateChange.getEntityType());
        if (!persistentEntity.hasVersionProperty()) {
            return null;
        }
        Object entity = aggregateChange.getEntity();
        if (entity == null) {
            return null;
        }
        return (Number)persistentEntity.getPropertyAccessor(entity).getProperty(persistentEntity.getRequiredVersionProperty());
    }
}

