/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class In
extends AbstractSegment
implements Condition {
    private final Expression left;
    private final Collection<Expression> expressions;
    private final boolean notIn;

    private In(Expression left, Collection<Expression> expressions, boolean notIn) {
        super(In.toArray(left, expressions));
        this.left = left;
        this.expressions = expressions;
        this.notIn = notIn;
    }

    private static Segment[] toArray(Expression expression, Collection<Expression> expressions) {
        Segment[] segments = new Segment[1 + expressions.size()];
        segments[0] = expression;
        int index = 1;
        for (Expression e : expressions) {
            segments[index++] = e;
        }
        return segments;
    }

    public static In create(Expression columnOrExpression, Expression arg) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)arg, (String)"Expression argument must not be null");
        return new In(columnOrExpression, Collections.singletonList(arg), false);
    }

    public static In create(Expression columnOrExpression, Collection<? extends Expression> expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull(expressions, (String)"Expression argument must not be null");
        return new In(columnOrExpression, new ArrayList<Expression>(expressions), false);
    }

    public static In create(Expression columnOrExpression, Expression ... expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)expressions, (String)"Expression argument must not be null");
        return new In(columnOrExpression, Arrays.asList(expressions), false);
    }

    public static In createNotIn(Expression columnOrExpression, Expression arg) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)arg, (String)"Expression argument must not be null");
        return new In(columnOrExpression, Collections.singletonList(arg), true);
    }

    public static In createNotIn(Expression columnOrExpression, Collection<? extends Expression> expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull(expressions, (String)"Expression argument must not be null");
        return new In(columnOrExpression, new ArrayList<Expression>(expressions), true);
    }

    public static In createNotIn(Expression columnOrExpression, Expression ... expressions) {
        Assert.notNull((Object)columnOrExpression, (String)"Comparison column or expression must not be null");
        Assert.notNull((Object)expressions, (String)"Expression argument must not be null");
        return new In(columnOrExpression, Arrays.asList(expressions), true);
    }

    @Override
    public Condition not() {
        return new In(this.left, this.expressions, !this.notIn);
    }

    @Override
    public String toString() {
        return this.left + (this.notIn ? " NOT" : "") + " IN (" + StringUtils.collectionToDelimitedString(this.expressions, (String)", ") + ")";
    }

    public boolean isNotIn() {
        return this.notIn;
    }
}

