/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import java.util.function.Predicate;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.ConditionVisitor;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.ExpressionVisitor;
import org.springframework.data.relational.core.sql.render.FilteredSubtreeVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.util.Assert;

abstract class FilteredSingleConditionRenderSupport
extends FilteredSubtreeVisitor {
    private final RenderContext context;
    private PartRenderer current;

    FilteredSingleConditionRenderSupport(RenderContext context, Predicate<Visitable> filter) {
        super(filter);
        this.context = context;
    }

    @Override
    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        if (segment instanceof Expression) {
            ExpressionVisitor visitor = new ExpressionVisitor(this.context);
            this.current = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        if (segment instanceof Condition) {
            ConditionVisitor visitor = new ConditionVisitor(this.context);
            this.current = visitor;
            return DelegatingVisitor.Delegation.delegateTo(visitor);
        }
        throw new IllegalStateException("Cannot provide visitor for " + segment);
    }

    protected boolean hasDelegatedRendering() {
        return this.current != null;
    }

    protected CharSequence consumeRenderedPart() {
        Assert.state((boolean)this.hasDelegatedRendering(), (String)"Rendering not delegated. Cannot consume delegated rendering part.");
        PartRenderer current = this.current;
        this.current = null;
        return current.getRenderedPart();
    }
}

