/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.util.Assert;

@NullUnmarked
class DefaultZSetOperations<K, V>
extends AbstractOperations<K, V>
implements ZSetOperations<K, V> {
    DefaultZSetOperations(@NonNull RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Boolean add(@NonNull K key, @NonNull V value, double score) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.zAdd(rawKey, score, rawValue));
    }

    @Override
    public Boolean addIfAbsent(@NonNull K key, @NonNull V value, double score) {
        return this.add(key, value, score, RedisZSetCommands.ZAddArgs.ifNotExists());
    }

    protected Boolean add(@NonNull K key, @NonNull V value, double score,  @NonNull RedisZSetCommands.ZAddArgs args) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.zAdd(rawKey, score, rawValue, args));
    }

    @Override
    public Long add(@NonNull K key, @NonNull Set<@NonNull ZSetOperations.TypedTuple<V>> tuples) {
        byte[] rawKey = this.rawKey(key);
        Set<Tuple> rawValues = this.rawTupleValues(tuples);
        return this.execute(connection -> connection.zAdd(rawKey, rawValues));
    }

    @Override
    public Long addIfAbsent(@NonNull K key, @NonNull Set<@NonNull ZSetOperations.TypedTuple<V>> tuples) {
        return this.add(key, tuples, RedisZSetCommands.ZAddArgs.ifNotExists());
    }

    protected Long add(@NonNull K key, @NonNull Set<@NonNull ZSetOperations.TypedTuple<V>> tuples,  @NonNull RedisZSetCommands.ZAddArgs args) {
        byte[] rawKey = this.rawKey(key);
        Set<Tuple> rawValues = this.rawTupleValues(tuples);
        return this.execute(connection -> connection.zAdd(rawKey, rawValues, args));
    }

    @Override
    public Double incrementScore(@NonNull K key, @NonNull V value, double delta) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.zIncrBy(rawKey, delta, rawValue));
    }

    @Override
    public V randomMember(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeValue(this.execute(connection -> connection.zRandMember(rawKey)));
    }

    @Override
    public Set<V> distinctRandomMembers(@NonNull K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported; Use randomMembers to allow duplicate elements");
        byte[] rawKey = this.rawKey(key);
        List result = this.execute(connection -> connection.zRandMember(rawKey, count));
        return result != null ? this.deserializeValues(new LinkedHashSet<byte[]>(result)) : null;
    }

    @Override
    public List<V> randomMembers(@NonNull K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count; This method is already allowing duplicate elements");
        byte[] rawKey = this.rawKey(key);
        List result = this.execute(connection -> connection.zRandMember(rawKey, count));
        return this.deserializeValues(result);
    }

    @Override
    public ZSetOperations.TypedTuple<V> randomMemberWithScore(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeTuple(this.execute(connection -> connection.zRandMemberWithScore(rawKey)));
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(@NonNull K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported; Use randomMembers to allow duplicate elements");
        byte[] rawKey = this.rawKey(key);
        List result = this.execute(connection -> connection.zRandMemberWithScore(rawKey, count));
        return result != null ? this.deserializeTupleValues(new LinkedHashSet<Tuple>(result)) : null;
    }

    @Override
    public List<ZSetOperations.TypedTuple<V>> randomMembersWithScore(@NonNull K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count; This method is already allowing duplicate elements");
        byte[] rawKey = this.rawKey(key);
        List result = this.execute(connection -> connection.zRandMemberWithScore(rawKey, count));
        return result != null ? this.deserializeTupleValues(result) : null;
    }

    @Override
    public Set<V> range(@NonNull K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRange(rawKey, start, end));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRange(@NonNull K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRange(rawKey, start, end));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeWithScores(@NonNull K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeWithScores(rawKey, start, end));
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(@NonNull K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeWithScores(rawKey, start, end));
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<V> rangeByLex(@NonNull K key, @NonNull Range<String> range, @NonNull Limit limit) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByLex(rawKey, this.serialize(range), limit));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByLex(@NonNull K key, @NonNull Range<String> range, @NonNull Limit limit) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByLex(rawKey, this.serialize(range), limit));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Long rangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range, @NonNull Limit limit) {
        byte[] rawDstKey = this.rawKey(dstKey);
        byte[] rawSrcKey = this.rawKey(srcKey);
        return this.execute(connection -> connection.zRangeStoreByLex(rawDstKey, rawSrcKey, this.serialize(range), limit));
    }

    @Override
    public Long reverseRangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range, @NonNull Limit limit) {
        byte[] rawDstKey = this.rawKey(dstKey);
        byte[] rawSrcKey = this.rawKey(srcKey);
        return this.execute(connection -> connection.zRangeStoreRevByLex(rawDstKey, rawSrcKey, this.serialize(range), limit));
    }

    @Override
    public Long rangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        byte[] rawDstKey = this.rawKey(dstKey);
        byte[] rawSrcKey = this.rawKey(srcKey);
        return this.execute(connection -> connection.zRangeStoreByScore(rawDstKey, rawSrcKey, range, limit));
    }

    @Override
    public Long reverseRangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        byte[] rawDstKey = this.rawKey(dstKey);
        byte[] rawSrcKey = this.rawKey(srcKey);
        return this.execute(connection -> connection.zRangeStoreRevByScore(rawDstKey, rawSrcKey, range, limit));
    }

    @Override
    public Set<V> rangeByScore(@NonNull K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScore(rawKey, min, max));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> rangeByScore(@NonNull K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScore(rawKey, min, max, offset, count));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByScore(@NonNull K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScore(rawKey, min, max));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> reverseRangeByScore(@NonNull K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScore(rawKey, min, max, offset, count));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(@NonNull K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScoreWithScores(rawKey, min, max));
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(@NonNull K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRangeByScoreWithScores(rawKey, min, max, offset, count));
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScoreWithScores(rawKey, min, max));
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K key, double min, double max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.zRevRangeByScoreWithScores(rawKey, min, max, offset, count));
        return this.deserializeTupleValues(rawValues);
    }

    @Override
    public Long rank(@NonNull K key, @NonNull Object value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> {
            Long zRank = connection.zRank(rawKey, rawValue);
            return zRank != null && zRank >= 0L ? zRank : null;
        });
    }

    @Override
    public Long reverseRank(@NonNull K key, @NonNull Object value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> {
            Long zRank = connection.zRevRank(rawKey, rawValue);
            return zRank != null && zRank >= 0L ? zRank : null;
        });
    }

    @Override
    public Long remove(@NonNull K key, Object ... values) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(values);
        return this.execute(connection -> connection.zRem(rawKey, rawValues));
    }

    @Override
    public Long removeRange(@NonNull K key, long start, long end) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRemRange(rawKey, start, end));
    }

    @Override
    public Long removeRangeByLex(@NonNull K key, @NonNull Range<String> range) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRemRangeByLex(rawKey, this.serialize(range)));
    }

    @Override
    public Long removeRangeByScore(@NonNull K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRemRangeByScore(rawKey, min, max));
    }

    @Override
    public Double score(@NonNull K key, Object value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawValue = this.rawValue(value);
        return this.execute(connection -> connection.zScore(rawKey, rawValue));
    }

    @Override
    public List<Double> score(@NonNull K key, Object ... o) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawValues = this.rawValues(o);
        return this.execute(connection -> connection.zMScore(rawKey, rawValues));
    }

    @Override
    public Long count(@NonNull K key, double min, double max) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zCount(rawKey, min, max));
    }

    @Override
    public Long lexCount(@NonNull K key, @NonNull Range<String> range) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zLexCount(rawKey, this.serialize(range)));
    }

    @Override
    public @Nullable ZSetOperations.TypedTuple<V> popMin(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeTuple(this.execute(connection -> connection.zPopMin(rawKey)));
    }

    @Override
    public @Nullable Set<ZSetOperations.TypedTuple<V>> popMin(@NonNull K key, long count) {
        byte[] rawKey = this.rawKey(key);
        Set result = this.execute(connection -> connection.zPopMin(rawKey, count));
        return this.deserializeTupleValues(new LinkedHashSet<Tuple>(result));
    }

    @Override
    public @Nullable ZSetOperations.TypedTuple<V> popMin(@NonNull K key, long timeout, @NonNull TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeTuple(this.execute(connection -> connection.bZPopMin(rawKey, timeout, unit)));
    }

    @Override
    public @Nullable ZSetOperations.TypedTuple<V> popMax(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeTuple(this.execute(connection -> connection.zPopMax(rawKey)));
    }

    @Override
    public @Nullable Set<ZSetOperations.TypedTuple<V>> popMax(@NonNull K key, long count) {
        byte[] rawKey = this.rawKey(key);
        Set result = this.execute(connection -> connection.zPopMax(rawKey, count));
        return this.deserializeTupleValues(new LinkedHashSet<Tuple>(result));
    }

    @Override
    public @Nullable ZSetOperations.TypedTuple<V> popMax(@NonNull K key, long timeout, @NonNull TimeUnit unit) {
        byte[] rawKey = this.rawKey(key);
        return this.deserializeTuple(this.execute(connection -> connection.bZPopMax(rawKey, timeout, unit)));
    }

    @Override
    public Long size(@NonNull K key) {
        return this.zCard(key);
    }

    @Override
    public Long zCard(@NonNull K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zCard(rawKey));
    }

    @Override
    public Set<V> difference(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set rawValues = this.execute(connection -> connection.zDiff(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> differenceWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set result = this.execute(connection -> connection.zDiffWithScores(rawKeys));
        return this.deserializeTupleValues(new LinkedHashSet<Tuple>(result));
    }

    @Override
    public Long differenceAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zDiffStore(rawDestKey, rawKeys));
    }

    @Override
    public Set<V> intersect(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set rawValues = this.execute(connection -> connection.zInter(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set result = this.execute(connection -> connection.zInterWithScores(rawKeys));
        return this.deserializeTupleValues(result);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull Aggregate aggregate, @NonNull Weights weights) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set result = this.execute(connection -> connection.zInterWithScores(aggregate, weights, rawKeys));
        return this.deserializeTupleValues(result);
    }

    @Override
    public Long intersectAndStore(@NonNull K key, @NonNull K otherKey, @NonNull K destKey) {
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long intersectAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zInterStore(rawDestKey, rawKeys));
    }

    @Override
    public Long intersectAndStore(@NonNull K key, Collection<@NonNull K> otherKeys, @NonNull K destKey, @NonNull Aggregate aggregate, @NonNull Weights weights) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zInterStore(rawDestKey, aggregate, weights, rawKeys));
    }

    @Override
    public Set<V> union(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set rawValues = this.execute(connection -> connection.zUnion(rawKeys));
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set result = this.execute(connection -> connection.zUnionWithScores(rawKeys));
        return this.deserializeTupleValues(result);
    }

    @Override
    public Set<ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull Aggregate aggregate, @NonNull Weights weights) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        Set result = this.execute(connection -> connection.zUnionWithScores(aggregate, weights, rawKeys));
        return this.deserializeTupleValues(result);
    }

    @Override
    public Long unionAndStore(@NonNull K key, @NonNull K otherKey, @NonNull K destKey) {
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Long unionAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zUnionStore(rawDestKey, rawKeys));
    }

    @Override
    public Long unionAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey, @NonNull Aggregate aggregate, @NonNull Weights weights) {
        byte[][] rawKeys = this.rawKeys(key, otherKeys);
        byte[] rawDestKey = this.rawKey(destKey);
        return this.execute(connection -> connection.zUnionStore(rawDestKey, aggregate, weights, rawKeys));
    }

    @Override
    public Cursor<ZSetOperations.TypedTuple<V>> scan(@NonNull K key, @Nullable ScanOptions options) {
        byte[] rawKey = this.rawKey(key);
        Cursor cursor = this.template.executeWithStickyConnection(connection -> connection.zScan(rawKey, options));
        return new ConvertingCursor(cursor, this::deserializeTuple);
    }

    public Set<byte[]> rangeByScore(@NonNull K key, String min, String max) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRangeByScore(rawKey, min, max));
    }

    public Set<byte[]> rangeByScore(@NonNull K key, String min, String max, long offset, long count) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.zRangeByScore(rawKey, min, max, offset, count));
    }

    private Range<byte[]> serialize(Range<String> range) {
        if (!range.getLowerBound().isBounded() && !range.getUpperBound().isBounded()) {
            return Range.unbounded();
        }
        Range.Bound<byte[]> lower = this.rawBound((Range.Bound<String>)range.getLowerBound());
        Range.Bound<byte[]> upper = this.rawBound((Range.Bound<String>)range.getUpperBound());
        return Range.of(lower, upper);
    }

    private Range.Bound<byte[]> rawBound(Range.Bound<String> source) {
        return source.getValue().map(this::rawString).map(it -> source.isInclusive() ? Range.Bound.inclusive((Object)it) : Range.Bound.exclusive((Object)it)).orElseGet(Range.Bound::unbounded);
    }
}

