/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.Assert;

@NullUnmarked
public interface BoundListOperations<K, V>
extends BoundKeyOperations<K> {
    public List<V> range(long var1, long var3);

    public void trim(long var1, long var3);

    public Long size();

    public Long leftPush(V var1);

    public Long leftPushAll(V ... var1);

    public Long leftPushIfPresent(V var1);

    public Long leftPush(@NonNull V var1, V var2);

    public Long rightPush(V var1);

    public Long rightPushAll(V ... var1);

    public Long rightPushIfPresent(V var1);

    public Long rightPush(@NonNull V var1, V var2);

    public V move( @NonNull RedisListCommands.Direction var1, @NonNull K var2,  @NonNull RedisListCommands.Direction var3);

    public V move( @NonNull RedisListCommands.Direction var1, @NonNull K var2,  @NonNull RedisListCommands.Direction var3, @NonNull Duration var4);

    public V move( @NonNull RedisListCommands.Direction var1, @NonNull K var2,  @NonNull RedisListCommands.Direction var3, long var4, @NonNull TimeUnit var6);

    public void set(long var1, V var3);

    public Long remove(long var1, Object var3);

    public V getFirst();

    public V getLast();

    public V index(long var1);

    public Long indexOf(V var1);

    public Long lastIndexOf(V var1);

    public V leftPop();

    public List<V> leftPop(long var1);

    public V leftPop(long var1, @NonNull TimeUnit var3);

    default public V leftPop(Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.leftPop(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public V rightPop();

    public List<V> rightPop(long var1);

    public V rightPop(long var1, @NonNull TimeUnit var3);

    default public V rightPop(@NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.rightPop(TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    @Override
    public @NonNull RedisOperations<K, V> getOperations();
}

