/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.KeyValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceListCommands;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@NullUnmarked
class LettuceClusterListCommands
extends LettuceListCommands {
    private final LettuceClusterConnection connection;

    LettuceClusterListCommands(@NonNull LettuceClusterConnection connection) {
        super(connection);
        this.connection = connection;
    }

    @Override
    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.bLPop(timeout, keys);
        }
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.blpop((long)timeout, (Object[])new byte[][]{key}), Arrays.asList(keys)).resultsAsList();
        for (KeyValue kv : resultList) {
            if (kv == null) continue;
            return LettuceConverters.toBytesList((KeyValue<byte[], byte[]>)kv);
        }
        return Collections.emptyList();
    }

    @Override
    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            return super.bRPop(timeout, keys);
        }
        List resultList = this.connection.getClusterCommandExecutor().executeMultiKeyCommand((client, key) -> client.brpop((long)timeout, (Object[])new byte[][]{key}), Arrays.asList(keys)).resultsAsList();
        for (KeyValue kv : resultList) {
            if (kv == null) continue;
            return LettuceConverters.toBytesList((KeyValue<byte[], byte[]>)kv);
        }
        return Collections.emptyList();
    }

    @Override
    public byte[] rPopLPush(byte @NonNull [] srcKey, byte @NonNull [] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            return super.rPopLPush(srcKey, dstKey);
        }
        byte[] val = this.rPop(srcKey);
        this.lPush(dstKey, new byte[][]{val});
        return val;
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte @NonNull [] srcKey, byte @NonNull [] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(srcKey, dstKey)) {
            return super.bRPopLPush(timeout, srcKey, dstKey);
        }
        List<byte[]> val = this.bRPop(timeout, new byte[][]{srcKey});
        if (!CollectionUtils.isEmpty(val)) {
            this.lPush(dstKey, new byte[][]{val.get(1)});
            return val.get(1);
        }
        return null;
    }
}

