/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@NullUnmarked
public interface ReactiveZSetOperations<K, V> {
    public Mono<Boolean> add(@NonNull K var1, @NonNull V var2, double var3);

    public Mono<Long> addAll(@NonNull K var1, @NonNull Collection<? extends  @NonNull ZSetOperations.TypedTuple<V>> var2);

    public Mono<Long> remove(@NonNull K var1, Object ... var2);

    public Mono<Double> incrementScore(@NonNull K var1, @NonNull V var2, double var3);

    public Mono<V> randomMember(@NonNull K var1);

    public Flux<V> distinctRandomMembers(@NonNull K var1, long var2);

    public Flux<V> randomMembers(@NonNull K var1, long var2);

    public Mono<ZSetOperations.TypedTuple<V>> randomMemberWithScore(@NonNull K var1);

    public Flux<ZSetOperations.TypedTuple<V>> distinctRandomMembersWithScore(@NonNull K var1, long var2);

    public Flux<ZSetOperations.TypedTuple<V>> randomMembersWithScore(@NonNull K var1, long var2);

    public Mono<Long> rank(@NonNull K var1, @NonNull Object var2);

    public Mono<Long> reverseRank(@NonNull K var1, @NonNull Object var2);

    public Flux<V> range(@NonNull K var1, @NonNull Range<Long> var2);

    public Flux<ZSetOperations.TypedTuple<V>> rangeWithScores(@NonNull K var1, @NonNull Range<Long> var2);

    public Flux<V> rangeByScore(@NonNull K var1, @NonNull Range<Double> var2);

    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(@NonNull K var1, @NonNull Range<Double> var2);

    public Flux<V> rangeByScore(@NonNull K var1, @NonNull Range<Double> var2, @NonNull Limit var3);

    public Flux<ZSetOperations.TypedTuple<V>> rangeByScoreWithScores(@NonNull K var1, @NonNull Range<Double> var2, @NonNull Limit var3);

    public Flux<V> reverseRange(@NonNull K var1, @NonNull Range<Long> var2);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeWithScores(@NonNull K var1, @NonNull Range<Long> var2);

    public Flux<V> reverseRangeByScore(@NonNull K var1, @NonNull Range<Double> var2);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K var1, @NonNull Range<Double> var2);

    public Flux<V> reverseRangeByScore(@NonNull K var1, @NonNull Range<Double> var2, @NonNull Limit var3);

    public Flux<ZSetOperations.TypedTuple<V>> reverseRangeByScoreWithScores(@NonNull K var1, @NonNull Range<Double> var2, @NonNull Limit var3);

    default public Mono<Long> rangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range) {
        return this.rangeAndStoreByLex(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> rangeAndStoreByLex(@NonNull K var1, @NonNull K var2, @NonNull Range<String> var3, @NonNull Limit var4);

    default public Mono<Long> reverseRangeAndStoreByLex(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<String> range) {
        return this.reverseRangeAndStoreByLex(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> reverseRangeAndStoreByLex(@NonNull K var1, @NonNull K var2, @NonNull Range<String> var3, @NonNull Limit var4);

    default public @Nullable Mono<Long> rangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<Double> range) {
        return this.rangeAndStoreByScore(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> rangeAndStoreByScore(@NonNull K var1, @NonNull K var2, @NonNull Range<Double> var3, @NonNull Limit var4);

    default public Mono<Long> reverseRangeAndStoreByScore(@NonNull K srcKey, @NonNull K dstKey, @NonNull Range<Double> range) {
        return this.reverseRangeAndStoreByScore(srcKey, dstKey, range, Limit.unlimited());
    }

    public Mono<Long> reverseRangeAndStoreByScore(@NonNull K var1, @NonNull K var2, @NonNull Range<Double> var3, @NonNull Limit var4);

    default public Flux<ZSetOperations.TypedTuple<V>> scan(@NonNull K key) {
        return this.scan(key, ScanOptions.NONE);
    }

    public Flux<ZSetOperations.TypedTuple<V>> scan(@NonNull K var1, @Nullable ScanOptions var2);

    public Mono<Long> count(@NonNull K var1, @NonNull Range<Double> var2);

    public Mono<Long> lexCount(@NonNull K var1, @NonNull Range<String> var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMin(@NonNull K var1);

    public Flux<ZSetOperations.TypedTuple<V>> popMin(@NonNull K var1, long var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMin(@NonNull K var1, Duration var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMax(@NonNull K var1);

    public Flux<ZSetOperations.TypedTuple<V>> popMax(@NonNull K var1, long var2);

    public Mono<ZSetOperations.TypedTuple<V>> popMax(@NonNull K var1, @NonNull Duration var2);

    public Mono<Long> size(@NonNull K var1);

    public Mono<Double> score(@NonNull K var1, @NonNull Object var2);

    public Mono<List<Double>> score(@NonNull K var1, Object ... var2);

    public Mono<Long> removeRange(@NonNull K var1, @NonNull Range<Long> var2);

    public Mono<Long> removeRangeByLex(@NonNull K var1, @NonNull Range<String> var2);

    public Mono<Long> removeRangeByScore(@NonNull K var1, @NonNull Range<Double> var2);

    default public Flux<V> difference(@NonNull K key, @NonNull K otherKey) {
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<V> difference(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> differenceWithScores(@NonNull K key, @NonNull K otherKey) {
        return this.differenceWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<ZSetOperations.TypedTuple<V>> differenceWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Mono<Long> differenceAndStore(@NonNull K key, @NonNull K otherKey, @NonNull K destKey) {
        return this.differenceAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public Mono<Long> differenceAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3);

    default public Flux<V> intersect(@NonNull K key, @NonNull K otherKey) {
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<V> intersect(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K key, @NonNull K otherKey) {
        return this.intersectWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K key, @NonNull Collection<K> otherKeys, @NonNull Aggregate aggregate) {
        return this.intersectWithScores(key, otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Flux<ZSetOperations.TypedTuple<V>> intersectWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull Aggregate var3, @NonNull Weights var4);

    default public Mono<Long> intersectAndStore(@NonNull K key, @NonNull K otherKey, @NonNull K destKey) {
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    public Mono<Long> intersectAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3);

    default public Mono<Long> intersectAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey, @NonNull Aggregate aggregate) {
        return this.intersectAndStore(key, otherKeys, destKey, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Mono<Long> intersectAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3, @NonNull Aggregate var4, @NonNull Weights var5);

    default public Flux<V> union(@NonNull K key, @NonNull K otherKey) {
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<V> union(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K key, @NonNull K otherKey) {
        return this.unionWithScores(key, (Collection<K>)Collections.singleton(otherKey));
    }

    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2);

    default public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull Aggregate aggregate) {
        return this.unionWithScores(key, otherKeys, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Flux<ZSetOperations.TypedTuple<V>> unionWithScores(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull Aggregate var3, @NonNull Weights var4);

    public Mono<Long> unionAndStore(@NonNull K var1, @NonNull K var2, @NonNull K var3);

    public Mono<Long> unionAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3);

    default public Mono<Long> unionAndStore(@NonNull K key, @NonNull Collection<@NonNull K> otherKeys, @NonNull K destKey, @NonNull Aggregate aggregate) {
        return this.unionAndStore(key, otherKeys, destKey, aggregate, Weights.fromSetCount(1 + otherKeys.size()));
    }

    public Mono<Long> unionAndStore(@NonNull K var1, @NonNull Collection<@NonNull K> var2, @NonNull K var3, @NonNull Aggregate var4, @NonNull Weights var5);

    public Flux<V> rangeByLex(@NonNull K var1, @NonNull Range<String> var2);

    public Flux<V> rangeByLex(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    public Flux<V> reverseRangeByLex(@NonNull K var1, @NonNull Range<String> var2);

    public Flux<V> reverseRangeByLex(@NonNull K var1, @NonNull Range<String> var2, @NonNull Limit var3);

    public Mono<Boolean> delete(@NonNull K var1);
}

