/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisKeyValueTemplate;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.repository.cdi.CdiBean;
import org.springframework.util.Assert;

public class RedisKeyValueTemplateBean
extends CdiBean<KeyValueOperations> {
    private final Bean<RedisKeyValueAdapter> keyValueAdapter;

    public RedisKeyValueTemplateBean(Bean<RedisKeyValueAdapter> keyValueAdapter, Set<Annotation> qualifiers, BeanManager beanManager) {
        super(qualifiers, KeyValueOperations.class, beanManager);
        Assert.notNull(keyValueAdapter, (String)"KeyValueAdapter bean must not be null");
        this.keyValueAdapter = keyValueAdapter;
    }

    public KeyValueOperations create(CreationalContext<KeyValueOperations> creationalContext) {
        RedisKeyValueAdapter keyValueAdapter = this.getDependencyInstance(this.keyValueAdapter, (Type)((Object)RedisKeyValueAdapter.class));
        RedisMappingContext redisMappingContext = new RedisMappingContext();
        redisMappingContext.afterPropertiesSet();
        return new RedisKeyValueTemplate(keyValueAdapter, redisMappingContext);
    }

    @Override
    public void destroy(KeyValueOperations instance, CreationalContext<KeyValueOperations> creationalContext) {
        if (instance.getMappingContext() instanceof DisposableBean) {
            try {
                ((DisposableBean)instance.getMappingContext()).destroy();
                instance.destroy();
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
        super.destroy(instance, creationalContext);
    }
}

