/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce.observability;

import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.tracing.TraceContext;
import io.lettuce.core.tracing.TraceContextProvider;
import io.lettuce.core.tracing.Tracer;
import io.lettuce.core.tracing.TracerProvider;
import io.lettuce.core.tracing.Tracing;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.ObservationView;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.connection.lettuce.observability.DefaultLettuceObservationConvention;
import org.springframework.data.redis.connection.lettuce.observability.LettuceObservationContext;
import org.springframework.data.redis.connection.lettuce.observability.LettuceObservationConvention;
import org.springframework.data.redis.connection.lettuce.observability.RedisObservation;
import org.springframework.data.redis.connection.lettuce.observability.SocketAddressEndpoint;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

public class MicrometerTracingAdapter
implements Tracing {
    private static final Log log = LogFactory.getLog(MicrometerTracingAdapter.class);
    private final ObservationRegistry observationRegistry;
    private final String serviceName;
    private final boolean includeCommandArgsInSpanTags;
    private final LettuceObservationConvention observationConvention;

    public MicrometerTracingAdapter(ObservationRegistry observationRegistry, String serviceName) {
        this(observationRegistry, serviceName, false);
    }

    public MicrometerTracingAdapter(ObservationRegistry observationRegistry, String serviceName, boolean includeCommandArgsInSpanTags) {
        this.observationRegistry = observationRegistry;
        this.serviceName = serviceName;
        this.observationConvention = new DefaultLettuceObservationConvention(includeCommandArgsInSpanTags);
        this.includeCommandArgsInSpanTags = includeCommandArgsInSpanTags;
    }

    public TracerProvider getTracerProvider() {
        return () -> new MicrometerTracer(this.observationRegistry);
    }

    public TraceContextProvider initialTraceContextProvider() {
        return new MicrometerTraceContextProvider(this.observationRegistry);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean includeCommandArgsInSpanTags() {
        return this.includeCommandArgsInSpanTags;
    }

    public Tracing.Endpoint createEndpoint(SocketAddress socketAddress) {
        return new SocketAddressEndpoint(socketAddress);
    }

    record MicrometerTraceContextProvider(ObservationRegistry registry) implements TraceContextProvider
    {
        @Nullable
        public TraceContext getTraceContext() {
            Observation observation = this.registry.getCurrentObservation();
            if (observation == null) {
                return null;
            }
            return new MicrometerTraceContext(observation);
        }

        public Mono<TraceContext> getTraceContextLater() {
            return Mono.deferContextual(Mono::justOrEmpty).filter(it -> it.hasKey(TraceContext.class) || it.hasKey(Observation.class) || it.hasKey((Object)"micrometer.observation")).map(it -> {
                if (it.hasKey(Observation.class)) {
                    return new MicrometerTraceContext((Observation)it.get(Observation.class));
                }
                if (it.hasKey(TraceContext.class)) {
                    return (TraceContext)it.get(TraceContext.class);
                }
                return new MicrometerTraceContext((Observation)it.get((Object)"micrometer.observation"));
            });
        }
    }

    public class MicrometerTracer
    extends Tracer {
        private final ObservationRegistry observationRegistry;

        public MicrometerTracer(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }

        public Tracer.Span nextSpan() {
            return this.postProcessSpan(this.createObservation(null));
        }

        public Tracer.Span nextSpan(TraceContext traceContext) {
            return this.postProcessSpan(this.createObservation(traceContext));
        }

        private Observation createObservation(@Nullable TraceContext parentContext) {
            return RedisObservation.REDIS_COMMAND_OBSERVATION.observation(this.observationRegistry, () -> {
                LettuceObservationContext context = new LettuceObservationContext(MicrometerTracingAdapter.this.serviceName);
                if (parentContext instanceof MicrometerTraceContext) {
                    MicrometerTraceContext traceContext = (MicrometerTraceContext)parentContext;
                    context.setParentObservation((ObservationView)traceContext.observation());
                }
                return context;
            });
        }

        private Tracer.Span postProcessSpan(Observation observation) {
            return !observation.isNoop() ? new MicrometerSpan(observation.observationConvention((ObservationConvention)MicrometerTracingAdapter.this.observationConvention)) : NoOpSpan.INSTANCE;
        }
    }

    record MicrometerTraceContext(Observation observation) implements TraceContext
    {
    }

    static class MicrometerSpan
    extends Tracer.Span {
        private final Observation observation;
        @Nullable
        private RedisCommand<?, ?, ?> command;

        public MicrometerSpan(Observation observation) {
            this.observation = observation;
        }

        public Tracer.Span start(RedisCommand<?, ?, ?> command) {
            ((LettuceObservationContext)this.observation.getContext()).setCommand(command);
            this.command = command;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting Observation for Command %s".formatted(command));
            }
            if (!(command instanceof CompleteableCommand)) {
                throw new IllegalArgumentException("Command " + String.valueOf(command) + " must implement CompleteableCommand to attach Span completion to command completion");
            }
            CompleteableCommand completeableCommand = (CompleteableCommand)command;
            completeableCommand.onComplete((o, throwable) -> {
                if (command.getOutput() != null) {
                    String error = command.getOutput().getError();
                    if (error != null) {
                        this.observation.highCardinalityKeyValue(RedisObservation.HighCardinalityCommandKeyNames.ERROR.withValue(error));
                    } else if (throwable != null) {
                        this.error((Throwable)throwable);
                    }
                }
                this.finish();
            });
            this.observation.start();
            return this;
        }

        public Tracer.Span name(String name) {
            return this;
        }

        public Tracer.Span annotate(String annotation) {
            return this;
        }

        public Tracer.Span tag(String key, String value) {
            this.observation.highCardinalityKeyValue(key, value);
            return this;
        }

        public Tracer.Span error(Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attaching error to Observation for Command %s".formatted(this.command));
            }
            this.observation.error(throwable);
            return this;
        }

        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            ((LettuceObservationContext)this.observation.getContext()).setEndpoint(endpoint);
            return this;
        }

        public void finish() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Stopping Observation for Command %s".formatted(this.command));
            }
            this.observation.stop();
        }
    }

    static class NoOpSpan
    extends Tracer.Span {
        static final NoOpSpan INSTANCE = new NoOpSpan();

        public Tracer.Span start(RedisCommand<?, ?, ?> command) {
            return this;
        }

        public Tracer.Span name(String name) {
            return this;
        }

        public Tracer.Span annotate(String value) {
            return this;
        }

        public Tracer.Span tag(String key, String value) {
            return this;
        }

        public Tracer.Span error(Throwable throwable) {
            return this;
        }

        public Tracer.Span remoteEndpoint(Tracing.Endpoint endpoint) {
            return this;
        }

        public void finish() {
        }
    }
}

