/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.script;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisSerializer;

class ScriptUtils {
    private ScriptUtils() {
    }

    static <T> T deserializeResult(RedisSerializer<T> resultSerializer, Object result) {
        if (result instanceof byte[]) {
            byte[] resultBytes = (byte[])result;
            return resultSerializer.deserialize(resultBytes);
        }
        if (result instanceof List) {
            List listResult = (List)result;
            ArrayList<T> results = new ArrayList<T>(listResult.size());
            for (Object obj : listResult) {
                results.add(ScriptUtils.deserializeResult(resultSerializer, obj));
            }
            return (T)results;
        }
        return (T)result;
    }

    static <T> T deserializeResult(RedisElementReader<T> reader, Object result) {
        if (result instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)result;
            return reader.read(byteBuffer);
        }
        if (result instanceof List) {
            List listResult = (List)result;
            ArrayList<T> results = new ArrayList<T>(listResult.size());
            for (Object obj : listResult) {
                results.add(ScriptUtils.deserializeResult(reader, obj));
            }
            return (T)results;
        }
        return (T)result;
    }

    static boolean exceptionContainsNoScriptError(Throwable e) {
        if (!(e instanceof NonTransientDataAccessException)) {
            return false;
        }
        for (Throwable current = e; current != null; current = current.getCause()) {
            String exMessage = current.getMessage();
            if (exMessage == null || !exMessage.contains("NOSCRIPT")) continue;
            return true;
        }
        return false;
    }
}

