/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.lang.Nullable;

public interface RedisStreamCommands {
    @Nullable
    default public Long xAck(byte[] key, String group, String ... recordIds) {
        return this.xAck(key, group, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    @Nullable
    public Long xAck(byte[] var1, String var2, RecordId ... var3);

    @Nullable
    default public RecordId xAdd(byte[] key, Map<byte[], byte[]> content) {
        return this.xAdd(StreamRecords.newRecord().in(key).ofMap(content));
    }

    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> var1);

    @Nullable
    default public Long xDel(byte[] key, String ... recordIds) {
        return this.xDel(key, (RecordId[])Arrays.stream(recordIds).map(RecordId::of).toArray(RecordId[]::new));
    }

    public Long xDel(byte[] var1, RecordId ... var2);

    @Nullable
    public String xGroupCreate(byte[] var1, String var2, ReadOffset var3);

    @Nullable
    default public Boolean xGroupDelConsumer(byte[] key, String groupName, String consumerName) {
        return this.xGroupDelConsumer(key, Consumer.from(groupName, consumerName));
    }

    @Nullable
    public Boolean xGroupDelConsumer(byte[] var1, Consumer var2);

    @Nullable
    public Boolean xGroupDestroy(byte[] var1, String var2);

    @Nullable
    public Long xLen(byte[] var1);

    @Nullable
    default public List<ByteRecord> xRange(byte[] key, Range<String> range) {
        return this.xRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<ByteRecord> xRange(byte[] var1, Range<String> var2, RedisZSetCommands.Limit var3);

    @Nullable
    default public List<ByteRecord> xRead(StreamOffset<byte[]> ... streams) {
        return this.xRead(StreamReadOptions.empty(), streams);
    }

    @Nullable
    public List<ByteRecord> xRead(StreamReadOptions var1, StreamOffset<byte[]> ... var2);

    @Nullable
    default public List<ByteRecord> xReadGroup(Consumer consumer, StreamOffset<byte[]> ... streams) {
        return this.xReadGroup(consumer, StreamReadOptions.empty(), streams);
    }

    @Nullable
    public List<ByteRecord> xReadGroup(Consumer var1, StreamReadOptions var2, StreamOffset<byte[]> ... var3);

    @Nullable
    default public List<ByteRecord> xRevRange(byte[] key, Range<String> range) {
        return this.xRevRange(key, range, RedisZSetCommands.Limit.unlimited());
    }

    @Nullable
    public List<ByteRecord> xRevRange(byte[] var1, Range<String> var2, RedisZSetCommands.Limit var3);

    @Nullable
    public Long xTrim(byte[] var1, long var2);
}

