/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Properties;
import lombok.NonNull;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JedisServerCommands
implements RedisServerCommands {
    private static final String SHUTDOWN_SCRIPT = "return redis.call('SHUTDOWN','%s')";
    @NonNull
    private final JedisConnection connection;

    @Override
    public void bgReWriteAof() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().bgrewriteaof()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().bgrewriteaof()));
                return;
            }
            this.connection.getJedis().bgrewriteaof();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void bgSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().bgsave()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().bgsave()));
                return;
            }
            this.connection.getJedis().bgsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long lastSave() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().lastsave()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().lastsave()));
                return null;
            }
            return this.connection.getJedis().lastsave();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void save() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().save()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().save()));
                return;
            }
            this.connection.getJedis().save();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long dbSize() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().dbSize()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().dbSize()));
                return null;
            }
            return this.connection.getJedis().dbSize();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushDb() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().flushDB()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().flushDB()));
                return;
            }
            this.connection.getJedis().flushDB();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void flushAll() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().flushAll()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().flushAll()));
                return;
            }
            this.connection.getJedis().flushAll();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().info(), JedisConverters.stringToProps()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().info(), JedisConverters.stringToProps()));
                return null;
            }
            return JedisConverters.toProperties(this.connection.getJedis().info());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Properties info(String section) {
        Assert.notNull((Object)section, (String)"Section must not be null!");
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        try {
            return JedisConverters.toProperties(this.connection.getJedis().info(section));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().shutdown()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().shutdown()));
                return;
            }
            this.connection.getJedis().shutdown();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void shutdown(RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        this.connection.eval(String.format(SHUTDOWN_SCRIPT, option.name()).getBytes(), ReturnType.STATUS, 0, new byte[0][]);
    }

    @Override
    public Properties getConfig(String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().configGet(pattern), Converters.listToPropertiesConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().configGet(pattern), Converters.listToPropertiesConverter()));
                return null;
            }
            return Converters.toProperties(this.connection.getJedis().configGet(pattern));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setConfig(String param, String value) {
        Assert.notNull((Object)param, (String)"Parameter must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().configSet(param, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().configSet(param, value)));
                return;
            }
            this.connection.getJedis().configSet(param, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void resetConfigStats() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().configResetStat()));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().configResetStat()));
                return;
            }
            this.connection.getJedis().configResetStat();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long time() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().time(), JedisConverters.toTimeConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().time(), JedisConverters.toTimeConverter()));
                return null;
            }
            return (Long)JedisConverters.toTimeConverter().convert((Object)this.connection.getJedis().time());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void killClient(String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT KILL' is not supported in transaction / pipline mode.");
        }
        try {
            this.connection.getJedis().clientKill(String.format("%s:%s", host, port));
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void setClientName(byte[] name) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("'CLIENT SETNAME' is not suppored in transacton / pipeline mode.");
        }
        this.connection.getJedis().clientSetname(name);
    }

    @Override
    public String getClientName() {
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        return this.connection.getJedis().clientGetname();
    }

    @Override
    public List<RedisClientInfo> getClientList() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'CLIENT LIST' is not supported in in pipeline / multi mode.");
        }
        return JedisConverters.toListOfRedisClientInformation(this.connection.getJedis().clientList());
    }

    @Override
    public void slaveOf(String host, int port) {
        Assert.hasText((String)host, (String)"Host must not be null for 'SLAVEOF' command.");
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        try {
            this.connection.getJedis().slaveof(host, port);
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void slaveOfNoOne() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException("'SLAVEOF' cannot be called in pipline / transaction mode.");
        }
        try {
            this.connection.getJedis().slaveofNoOne();
        }
        catch (Exception e) {
            throw this.convertJedisAccessException(e);
        }
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte[] key, RedisNode target, int dbIndex, @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)target, (String)"Target node must not be null!");
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse)));
                return;
            }
            this.connection.getJedis().migrate(JedisConverters.toBytes(target.getHost()), target.getPort().intValue(), key, dbIndex, timeoutToUse);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    public JedisServerCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

