/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.atomic;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.CompareAndSet;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisAtomicLong
extends Number
implements Serializable,
BoundKeyOperations<String> {
    private static final long serialVersionUID = 1L;
    private volatile String key;
    private final ValueOperations<String, Long> operations;
    private final RedisOperations<String, Long> generalOps;

    public RedisAtomicLong(String redisCounter, RedisConnectionFactory factory) {
        this(redisCounter, factory, null);
    }

    public RedisAtomicLong(String redisCounter, RedisConnectionFactory factory, long initialValue) {
        this(redisCounter, factory, (Long)initialValue);
    }

    private RedisAtomicLong(String redisCounter, RedisConnectionFactory factory, @Nullable Long initialValue) {
        Assert.hasText((String)redisCounter, (String)"a valid counter name is required");
        Assert.notNull((Object)factory, (String)"a valid factory is required");
        RedisTemplate<String, Long> redisTemplate = new RedisTemplate<String, Long>();
        redisTemplate.setKeySerializer(RedisSerializer.string());
        redisTemplate.setValueSerializer(new GenericToStringSerializer<Long>(Long.class));
        redisTemplate.setExposeConnection(true);
        redisTemplate.setConnectionFactory(factory);
        redisTemplate.afterPropertiesSet();
        this.key = redisCounter;
        this.generalOps = redisTemplate;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            if (this.operations.get(redisCounter) == null) {
                this.set(0L);
            }
        } else {
            this.set(initialValue);
        }
    }

    public RedisAtomicLong(String redisCounter, RedisOperations<String, Long> template) {
        this(redisCounter, template, null);
    }

    public RedisAtomicLong(String redisCounter, RedisOperations<String, Long> template, long initialValue) {
        this(redisCounter, template, (Long)initialValue);
    }

    private RedisAtomicLong(String redisCounter, RedisOperations<String, Long> template, @Nullable Long initialValue) {
        Assert.hasText((String)redisCounter, (String)"a valid counter name is required");
        Assert.notNull(template, (String)"a valid template is required");
        Assert.notNull(template.getKeySerializer(), (String)"a valid key serializer in template is required");
        Assert.notNull(template.getValueSerializer(), (String)"a valid value serializer in template is required");
        this.key = redisCounter;
        this.generalOps = template;
        this.operations = this.generalOps.opsForValue();
        if (initialValue == null) {
            if (this.operations.get(redisCounter) == null) {
                this.set(0L);
            }
        } else {
            this.set(initialValue);
        }
    }

    public long get() {
        Long value = this.operations.get(this.key);
        if (value != null) {
            return value;
        }
        throw new DataRetrievalFailureException(String.format("The key '%s' seems to no longer exist.", this.key));
    }

    public void set(long newValue) {
        this.operations.set(this.key, newValue);
    }

    public long getAndSet(long newValue) {
        Long value = this.operations.getAndSet(this.key, newValue);
        return value != null ? value : 0L;
    }

    public boolean compareAndSet(long expect, long update) {
        return this.generalOps.execute(new CompareAndSet<Long>(this::get, this::set, this.key, expect, update));
    }

    public long getAndIncrement() {
        return this.incrementAndGet() - 1L;
    }

    public long getAndDecrement() {
        return this.decrementAndGet() + 1L;
    }

    public long getAndAdd(long delta) {
        return this.addAndGet(delta) - delta;
    }

    public long incrementAndGet() {
        return this.operations.increment(this.key, 1L);
    }

    public long decrementAndGet() {
        return this.operations.increment(this.key, -1L);
    }

    public long addAndGet(long delta) {
        return this.operations.increment(this.key, delta);
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public DataType getType() {
        return DataType.STRING;
    }

    @Override
    public Long getExpire() {
        return this.generalOps.getExpire(this.key);
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.generalOps.expire(this.key, timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.generalOps.expireAt(this.key, date);
    }

    @Override
    public Boolean persist() {
        return this.generalOps.persist(this.key);
    }

    @Override
    public void rename(String newKey) {
        this.generalOps.rename(this.key, newKey);
        this.key = newKey;
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }
}

