/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Optional;
import org.springframework.cache.interceptor.SimpleKey;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisCacheConfiguration {
    private final Duration ttl;
    private final boolean cacheNullValues;
    @Nullable
    private final String keyPrefix;
    private final boolean usePrefix;
    private final RedisSerializationContext.SerializationPair<String> keySerializationPair;
    private final RedisSerializationContext.SerializationPair<Object> valueSerializationPair;
    private final ConversionService conversionService;

    private RedisCacheConfiguration(Duration ttl, Boolean cacheNullValues, Boolean usePrefix, @Nullable String keyPrefix, RedisSerializationContext.SerializationPair<String> keySerializationPair, RedisSerializationContext.SerializationPair<?> valueSerializationPair, ConversionService conversionService) {
        this.ttl = ttl;
        this.cacheNullValues = cacheNullValues;
        this.usePrefix = usePrefix;
        this.keyPrefix = keyPrefix;
        this.keySerializationPair = keySerializationPair;
        this.valueSerializationPair = valueSerializationPair;
        this.conversionService = conversionService;
    }

    public static RedisCacheConfiguration defaultCacheConfig() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        RedisCacheConfiguration.registerDefaultConverters((ConverterRegistry)conversionService);
        return new RedisCacheConfiguration(Duration.ZERO, true, true, null, RedisSerializationContext.SerializationPair.fromSerializer(new StringRedisSerializer()), RedisSerializationContext.SerializationPair.fromSerializer(new JdkSerializationRedisSerializer()), (ConversionService)conversionService);
    }

    public RedisCacheConfiguration entryTtl(Duration ttl) {
        Assert.notNull((Object)ttl, (String)"TTL duration must not be null!");
        return new RedisCacheConfiguration(ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration prefixKeysWith(String prefix) {
        Assert.notNull((Object)prefix, (String)"Prefix must not be null!");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, true, prefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration disableCachingNullValues() {
        return new RedisCacheConfiguration(this.ttl, false, this.usePrefix, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration disableKeyPrefix() {
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, false, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration withConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.keySerializationPair, this.valueSerializationPair, conversionService);
    }

    public RedisCacheConfiguration serializeKeysWith(RedisSerializationContext.SerializationPair<String> keySerializationPair) {
        Assert.notNull(keySerializationPair, (String)"KeySerializationPair must not be null!");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, keySerializationPair, this.valueSerializationPair, this.conversionService);
    }

    public RedisCacheConfiguration serializeValuesWith(RedisSerializationContext.SerializationPair<?> valueSerializationPair) {
        Assert.notNull(valueSerializationPair, (String)"ValueSerializationPair must not be null!");
        return new RedisCacheConfiguration(this.ttl, this.cacheNullValues, this.usePrefix, this.keyPrefix, this.keySerializationPair, valueSerializationPair, this.conversionService);
    }

    public Optional<String> getKeyPrefix() {
        return Optional.ofNullable(this.keyPrefix);
    }

    public boolean usePrefix() {
        return this.usePrefix;
    }

    public boolean getAllowCacheNullValues() {
        return this.cacheNullValues;
    }

    public RedisSerializationContext.SerializationPair<String> getKeySerializationPair() {
        return this.keySerializationPair;
    }

    public RedisSerializationContext.SerializationPair<Object> getValueSerializationPair() {
        return this.valueSerializationPair;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public static void registerDefaultConverters(ConverterRegistry registry) {
        Assert.notNull((Object)registry, (String)"ConverterRegistry must not be null!");
        registry.addConverter(String.class, byte[].class, source -> source.getBytes(StandardCharsets.UTF_8));
        registry.addConverter(SimpleKey.class, String.class, SimpleKey::toString);
    }
}

