/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.nio.charset.StandardCharsets;
import java.util.Set;
import lombok.NonNull;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ZParams;

class JedisZSetCommands
implements RedisZSetCommands {
    @NonNull
    private final JedisConnection connection;

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zadd(key, score, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zadd(key, score, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().zadd(key, score, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zadd(key, JedisConverters.toTupleMap(tuples))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zadd(key, JedisConverters.toTupleMap(tuples))));
                return null;
            }
            return this.connection.getJedis().zadd(key, JedisConverters.toTupleMap(tuples));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrem(key, values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrem(key, values)));
                return null;
            }
            return this.connection.getJedis().zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zincrby(key, increment, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zincrby(key, increment, value)));
                return null;
            }
            return this.connection.getJedis().zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrank(key, value)));
                return null;
            }
            return this.connection.getJedis().zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrank(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrank(key, value)));
                return null;
            }
            return this.connection.getJedis().zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrange(key, start, end)));
                return null;
            }
            return this.connection.getJedis().zrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, @Nullable RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByScoreWithScores(key, min, max), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByScoreWithScores(key, min, max), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (limit != null) {
                return JedisConverters.toTupleSet(this.connection.getJedis().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrange(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrange(key, start, end)));
                return null;
            }
            return this.connection.getJedis().zrevrange(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrangeWithScores(key, start, end), JedisConverters.tupleSetToTupleSet()));
                return null;
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrevrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, @Nullable RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCORE must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount())));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrangeByScore(key, max, min)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount())));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrangeByScore(key, max, min)));
                }
                return null;
            }
            if (limit != null) {
                return this.connection.getJedis().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount());
            }
            return this.connection.getJedis().zrevrangeByScore(key, max, min);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, @Nullable RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCOREWITHSCORES must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrevrangeByScoreWithScores(key, max, min), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()), JedisConverters.tupleSetToTupleSet()));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrevrangeByScoreWithScores(key, max, min), JedisConverters.tupleSetToTupleSet()));
                }
                return null;
            }
            if (limit != null) {
                return JedisConverters.toTupleSet(this.connection.getJedis().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()));
            }
            return JedisConverters.toTupleSet(this.connection.getJedis().zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zcount(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zcount(key, min, max)));
                return null;
            }
            return this.connection.getJedis().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (this.isPipelined() || this.isQueueing()) {
            throw new UnsupportedOperationException("ZCOUNT not implemented in jedis for binary protocol on transaction and pipeline");
        }
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        return this.connection.getJedis().zcount(key, min, max);
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zcard(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zcard(key)));
                return null;
            }
            return this.connection.getJedis().zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zscore(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zscore(key, value)));
                return null;
            }
            return this.connection.getJedis().zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zremrangeByRank(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zremrangeByRank(key, start, end)));
                return null;
            }
            return this.connection.getJedis().zremrangeByRank(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREMRANGEBYSCORE must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zremrangeByScore(key, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zremrangeByScore(key, min, max)));
                return null;
            }
            return this.connection.getJedis().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zunionstore(destKey, zparams, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zunionstore(destKey, zparams, sets)));
                return null;
            }
            return this.connection.getJedis().zunionstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zunionstore(destKey, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zunionstore(destKey, sets)));
                return null;
            }
            return this.connection.getJedis().zunionstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, int[] weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        try {
            ZParams zparams = new ZParams().weights(weights).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zinterstore(destKey, zparams, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zinterstore(destKey, zparams, sets)));
                return null;
            }
            return this.connection.getJedis().zinterstore(destKey, zparams, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zinterstore(destKey, sets)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zinterstore(destKey, sets)));
                return null;
            }
            return this.connection.getJedis().zinterstore(destKey, sets);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, Long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId.longValue(), options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (JedisZSetCommands.this.isQueueing() || JedisZSetCommands.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisZSetCommands.this.connection.getJedis().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(result.getStringCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }

            @Override
            protected void doClose() {
                JedisZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            String keyStr = new String(key, StandardCharsets.UTF_8);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByScore(keyStr, min, max)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByScore(keyStr, min, max)));
                return null;
            }
            return JedisConverters.stringSetToByteSet().convert(this.connection.getJedis().zrangeByScore(keyStr, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Offset and count must be less than Integer.MAX_VALUE for zRangeByScore in Jedis.");
        }
        try {
            String keyStr = new String(key, StandardCharsets.UTF_8);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByScore(keyStr, min, max, (int)offset, (int)count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByScore(keyStr, min, max, (int)offset, (int)count)));
                return null;
            }
            return JedisConverters.stringSetToByteSet().convert(this.connection.getJedis().zrangeByScore(keyStr, min, max, (int)offset, (int)count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, @Nullable RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCORE must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getMin(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getMax(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByScore(key, min, max)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByScore(key, min, max)));
                }
                return null;
            }
            if (limit != null) {
                return this.connection.getJedis().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.connection.getJedis().zrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, @Nullable RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYLEX must not be null!");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex(range.getMin(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex(range.getMax(), JedisConverters.PLUS_BYTES);
        try {
            if (this.isPipelined()) {
                if (limit != null) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().zrangeByLex(key, min, max)));
                }
                return null;
            }
            if (this.isQueueing()) {
                if (limit != null) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount())));
                } else {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().zrangeByLex(key, min, max)));
                }
                return null;
            }
            if (limit != null) {
                return this.connection.getJedis().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount());
            }
            return this.connection.getJedis().zrangeByLex(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    public JedisZSetCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked @NonNull but is null");
        }
        this.connection = connection;
    }
}

