/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;

public class OxmSerializer
implements InitializingBean,
RedisSerializer<Object> {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public OxmSerializer() {
    }

    public OxmSerializer(Marshaller marshaller, Unmarshaller unmarshaller) {
        this.marshaller = marshaller;
        this.unmarshaller = unmarshaller;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.marshaller, (String)"non-null marshaller required");
        Assert.notNull((Object)this.unmarshaller, (String)"non-null unmarshaller required");
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.unmarshaller.unmarshal((Source)new StreamSource(new ByteArrayInputStream(bytes)));
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize bytes", ex);
        }
    }

    @Override
    public byte[] serialize(Object t) throws SerializationException {
        if (t == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        try {
            this.marshaller.marshal(t, (Result)result);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot serialize object", ex);
        }
        return stream.toByteArray();
    }
}

