/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.index;

import java.util.Collection;
import org.springframework.data.redis.core.index.IndexValueTransformer;
import org.springframework.data.util.TypeInformation;

public interface IndexDefinition {
    public String getKeyspace();

    public Collection<Condition<?>> getConditions();

    public IndexValueTransformer valueTransformer();

    public String getIndexName();

    public static class IndexingContext {
        private final String keyspace;
        private final String path;
        private final TypeInformation<?> typeInformation;

        public IndexingContext(String keyspace, String path, TypeInformation<?> typeInformation) {
            this.keyspace = keyspace;
            this.path = path;
            this.typeInformation = typeInformation;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getPath() {
            return this.path;
        }

        public TypeInformation<?> getTypeInformation() {
            return this.typeInformation;
        }
    }

    public static interface Condition<T> {
        public boolean matches(T var1, IndexingContext var2);
    }
}

