/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Arrays;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;

public class DefaultHyperLogLogOperations<K, V>
extends AbstractOperations<K, V>
implements HyperLogLogOperations<K, V> {
    public DefaultHyperLogLogOperations(RedisTemplate<K, V> template) {
        super(template);
    }

    @Override
    public Long add(K key, V ... values) {
        final byte[] rawKey = this.rawKey(key);
        final byte[][] rawValues = this.rawValues(values);
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.pfAdd(rawKey, rawValues);
            }
        }, true);
    }

    @Override
    public Long size(K ... keys) {
        final byte[][] rawKeys = this.rawKeys(Arrays.asList(keys));
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.pfCount(rawKeys);
            }
        }, true);
    }

    @Override
    public Long union(K destination, K ... sourceKeys) {
        final byte[] rawDestinationKey = this.rawKey(destination);
        final byte[][] rawSourceKeys = this.rawKeys(Arrays.asList(sourceKeys));
        return this.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                connection.pfMerge(rawDestinationKey, rawSourceKeys);
                return connection.pfCount(new byte[][]{rawDestinationKey});
            }
        }, true);
    }

    @Override
    public void delete(K key) {
        this.template.delete(key);
    }
}

