/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.KeyValue;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.ScoredValue;
import com.lambdaworks.redis.ScriptOutputType;
import com.lambdaworks.redis.SortArgs;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.SetArgs;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.LongToBooleanConverter;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class LettuceConverters
extends Converters {
    private static final Converter<Date, Long> DATE_TO_LONG;
    private static final Converter<List<byte[]>, Set<byte[]>> BYTES_LIST_TO_BYTES_SET;
    private static final Converter<byte[], String> BYTES_TO_STRING;
    private static final Converter<String, byte[]> STRING_TO_BYTES;
    private static final Converter<Set<byte[]>, List<byte[]>> BYTES_SET_TO_BYTES_LIST;
    private static final Converter<KeyValue<byte[], byte[]>, List<byte[]>> KEY_VALUE_TO_BYTES_LIST;
    private static final Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>> SCORED_VALUES_TO_TUPLE_SET;
    private static final Converter<List<ScoredValue<byte[]>>, List<RedisZSetCommands.Tuple>> SCORED_VALUES_TO_TUPLE_LIST;
    private static final Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple> SCORED_VALUE_TO_TUPLE;
    private static final Converter<Exception, DataAccessException> EXCEPTION_CONVERTER;
    private static final Converter<Long, Boolean> LONG_TO_BOOLEAN;
    private static final Converter<List<byte[]>, Map<byte[], byte[]>> BYTES_LIST_TO_MAP;
    private static final Converter<List<byte[]>, List<RedisZSetCommands.Tuple>> BYTES_LIST_TO_TUPLE_LIST_CONVERTER;
    private static final Converter<String[], List<RedisClientInfo>> STRING_TO_LIST_OF_CLIENT_INFO;
    private static final Converter<Partitions, List<RedisClusterNode>> PARTITIONS_TO_CLUSTER_NODES;
    private static Converter<com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode, RedisClusterNode> CLUSTER_NODE_TO_CLUSTER_NODE_CONVERTER;
    private static final Converter<List<byte[]>, Long> BYTES_LIST_TO_TIME_CONVERTER;
    public static final byte[] PLUS_BYTES;
    public static final byte[] MINUS_BYTES;
    public static final byte[] POSITIVE_INFINITY_BYTES;
    public static final byte[] NEGATIVE_INFINITY_BYTES;

    public static List<RedisZSetCommands.Tuple> toTuple(List<byte[]> list) {
        return (List)BYTES_LIST_TO_TUPLE_LIST_CONVERTER.convert(list);
    }

    public static Converter<List<byte[]>, List<RedisZSetCommands.Tuple>> bytesListToTupleListConverter() {
        return BYTES_LIST_TO_TUPLE_LIST_CONVERTER;
    }

    public static Converter<String, List<RedisClientInfo>> stringToRedisClientListConverter() {
        return new Converter<String, List<RedisClientInfo>>(){

            public List<RedisClientInfo> convert(String source) {
                if (!StringUtils.hasText((String)source)) {
                    return Collections.emptyList();
                }
                return (List)STRING_TO_LIST_OF_CLIENT_INFO.convert((Object)source.split("\\r?\\n"));
            }
        };
    }

    public static Converter<Date, Long> dateToLong() {
        return DATE_TO_LONG;
    }

    public static Converter<List<byte[]>, Set<byte[]>> bytesListToBytesSet() {
        return BYTES_LIST_TO_BYTES_SET;
    }

    public static Converter<byte[], String> bytesToString() {
        return BYTES_TO_STRING;
    }

    public static Converter<KeyValue<byte[], byte[]>, List<byte[]>> keyValueToBytesList() {
        return KEY_VALUE_TO_BYTES_LIST;
    }

    public static Converter<Set<byte[]>, List<byte[]>> bytesSetToBytesList() {
        return BYTES_SET_TO_BYTES_LIST;
    }

    public static Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>> scoredValuesToTupleSet() {
        return SCORED_VALUES_TO_TUPLE_SET;
    }

    public static Converter<List<ScoredValue<byte[]>>, List<RedisZSetCommands.Tuple>> scoredValuesToTupleList() {
        return SCORED_VALUES_TO_TUPLE_LIST;
    }

    public static Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple> scoredValueToTuple() {
        return SCORED_VALUE_TO_TUPLE;
    }

    public static Converter<Exception, DataAccessException> exceptionConverter() {
        return EXCEPTION_CONVERTER;
    }

    public static Converter<Long, Boolean> longToBooleanConverter() {
        return LONG_TO_BOOLEAN;
    }

    public static Long toLong(Date source) {
        return (Long)DATE_TO_LONG.convert((Object)source);
    }

    public static Set<byte[]> toBytesSet(List<byte[]> source) {
        return (Set)BYTES_LIST_TO_BYTES_SET.convert(source);
    }

    public static List<byte[]> toBytesList(KeyValue<byte[], byte[]> source) {
        return (List)KEY_VALUE_TO_BYTES_LIST.convert(source);
    }

    public static List<byte[]> toBytesList(Set<byte[]> source) {
        return (List)BYTES_SET_TO_BYTES_LIST.convert(source);
    }

    public static Set<RedisZSetCommands.Tuple> toTupleSet(List<ScoredValue<byte[]>> source) {
        return (Set)SCORED_VALUES_TO_TUPLE_SET.convert(source);
    }

    public static RedisZSetCommands.Tuple toTuple(ScoredValue<byte[]> source) {
        return (RedisZSetCommands.Tuple)SCORED_VALUE_TO_TUPLE.convert(source);
    }

    public static String toString(byte[] source) {
        return (String)BYTES_TO_STRING.convert((Object)source);
    }

    public static ScriptOutputType toScriptOutputType(ReturnType returnType) {
        switch (returnType) {
            case BOOLEAN: {
                return ScriptOutputType.BOOLEAN;
            }
            case MULTI: {
                return ScriptOutputType.MULTI;
            }
            case VALUE: {
                return ScriptOutputType.VALUE;
            }
            case INTEGER: {
                return ScriptOutputType.INTEGER;
            }
            case STATUS: {
                return ScriptOutputType.STATUS;
            }
        }
        throw new IllegalArgumentException("Return type " + (Object)((Object)returnType) + " is not a supported script output type");
    }

    public static boolean toBoolean(RedisListCommands.Position where) {
        Assert.notNull((Object)"list positions are mandatory");
        return !RedisListCommands.Position.AFTER.equals((Object)where);
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Map<byte[], byte[]> toMap(List<byte[]> source) {
        return (Map)BYTES_LIST_TO_MAP.convert(source);
    }

    public static Converter<List<byte[]>, Map<byte[], byte[]>> bytesListToMapConverter() {
        return BYTES_LIST_TO_MAP;
    }

    public static SortArgs toSortArgs(SortParameters params) {
        Boolean isAlpha;
        SortArgs args = new SortArgs();
        if (params == null) {
            return args;
        }
        if (params.getByPattern() != null) {
            args.by(new String(params.getByPattern(), LettuceCharsets.ASCII));
        }
        if (params.getLimit() != null) {
            args.limit(params.getLimit().getStart(), params.getLimit().getCount());
        }
        if (params.getGetPattern() != null) {
            byte[][] pattern;
            for (byte[] bs : pattern = params.getGetPattern()) {
                args.get(new String(bs, LettuceCharsets.ASCII));
            }
        }
        if (params.getOrder() != null) {
            if (params.getOrder() == SortParameters.Order.ASC) {
                args.asc();
            } else {
                args.desc();
            }
        }
        if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
            args.alpha();
        }
        return args;
    }

    public static List<RedisClientInfo> toListOfRedisClientInformation(String clientList) {
        return (List)LettuceConverters.stringToRedisClientListConverter().convert((Object)clientList);
    }

    public static byte[][] subarray(byte[][] input, int index) {
        if (input.length > index) {
            byte[][] output = new byte[input.length - index][];
            System.arraycopy(input, index, output, 0, output.length);
            return output;
        }
        return null;
    }

    public static String boundaryToStringForZRange(RedisZSetCommands.Range.Boundary boundary, String defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return defaultValue;
        }
        return LettuceConverters.boundaryToString(boundary, "", "(");
    }

    private static String boundaryToString(RedisZSetCommands.Range.Boundary boundary, String inclPrefix, String exclPrefix) {
        String prefix = boundary.isIncluding() ? inclPrefix : exclPrefix;
        String value = null;
        value = boundary.getValue() instanceof byte[] ? LettuceConverters.toString((byte[])boundary.getValue()) : boundary.getValue().toString();
        return prefix + value;
    }

    public static List<RedisServer> toListOfRedisServer(List<Map<String, String>> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<RedisServer> sentinels = new ArrayList<RedisServer>();
        for (Map<String, String> info : source) {
            sentinels.add(RedisServer.newServerFrom(Converters.toProperties(info)));
        }
        return sentinels;
    }

    public static RedisURI sentinelConfigurationToRedisURI(RedisSentinelConfiguration sentinelConfiguration) {
        Assert.notNull((Object)sentinelConfiguration, (String)"RedisSentinelConfiguration is required");
        Set<RedisNode> sentinels = sentinelConfiguration.getSentinels();
        RedisURI.Builder builder = null;
        for (RedisNode sentinel : sentinels) {
            if (builder == null) {
                builder = RedisURI.Builder.sentinel((String)sentinel.getHost(), (int)sentinel.getPort(), (String)sentinelConfiguration.getMaster().getName());
                continue;
            }
            builder.withSentinel(sentinel.getHost(), sentinel.getPort().intValue());
        }
        return builder.build();
    }

    public static byte[] toBytes(String source) {
        return (byte[])STRING_TO_BYTES.convert((Object)source);
    }

    public static byte[] toBytes(Integer source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Long source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Double source) {
        return LettuceConverters.toBytes(String.valueOf(source));
    }

    public static String boundaryToBytesForZRange(RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return LettuceConverters.toString(defaultValue);
        }
        return LettuceConverters.boundaryToBytes(boundary, new byte[0], LettuceConverters.toBytes("("));
    }

    public static String boundaryToBytesForZRangeByLex(RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return LettuceConverters.toString(defaultValue);
        }
        return LettuceConverters.boundaryToBytes(boundary, LettuceConverters.toBytes("["), LettuceConverters.toBytes("("));
    }

    private static String boundaryToBytes(RedisZSetCommands.Range.Boundary boundary, byte[] inclPrefix, byte[] exclPrefix) {
        byte[] prefix = boundary.isIncluding() ? inclPrefix : exclPrefix;
        byte[] value = null;
        if (boundary.getValue() instanceof byte[]) {
            value = (byte[])boundary.getValue();
        } else if (boundary.getValue() instanceof Double) {
            value = LettuceConverters.toBytes((Double)boundary.getValue());
        } else if (boundary.getValue() instanceof Long) {
            value = LettuceConverters.toBytes((Long)boundary.getValue());
        } else if (boundary.getValue() instanceof Integer) {
            value = LettuceConverters.toBytes((Integer)boundary.getValue());
        } else if (boundary.getValue() instanceof String) {
            value = LettuceConverters.toBytes((String)boundary.getValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot convert %s to binary format", boundary.getValue()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + value.length);
        buffer.put(prefix);
        buffer.put(value);
        return LettuceConverters.toString(buffer.array());
    }

    public static List<RedisClusterNode> partitionsToClusterNodes(Partitions partitions) {
        return (List)PARTITIONS_TO_CLUSTER_NODES.convert((Object)partitions);
    }

    public static RedisClusterNode toRedisClusterNode(com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode source) {
        return (RedisClusterNode)CLUSTER_NODE_TO_CLUSTER_NODE_CONVERTER.convert((Object)source);
    }

    public static SetArgs toSetArgs(Expiration expiration, RedisStringCommands.SetOption option) {
        SetArgs args = new SetArgs();
        if (expiration != null && !expiration.isPersistent()) {
            switch (expiration.getTimeUnit()) {
                case SECONDS: {
                    args.ex(expiration.getExpirationTime());
                    break;
                }
                default: {
                    args.px(expiration.getConverted(TimeUnit.MILLISECONDS));
                }
            }
        }
        if (option != null) {
            switch (option) {
                case SET_IF_ABSENT: {
                    args.nx();
                    break;
                }
                case SET_IF_PRESENT: {
                    args.xx();
                    break;
                }
            }
        }
        return args;
    }

    static Converter<List<byte[]>, Long> toTimeConverter() {
        return BYTES_LIST_TO_TIME_CONVERTER;
    }

    static {
        EXCEPTION_CONVERTER = new LettuceExceptionConverter();
        LONG_TO_BOOLEAN = new LongToBooleanConverter();
        STRING_TO_LIST_OF_CLIENT_INFO = new StringToRedisClientInfoConverter();
        DATE_TO_LONG = new Converter<Date, Long>(){

            public Long convert(Date source) {
                return source != null ? Long.valueOf(source.getTime()) : null;
            }
        };
        BYTES_LIST_TO_BYTES_SET = new Converter<List<byte[]>, Set<byte[]>>(){

            public Set<byte[]> convert(List<byte[]> results) {
                return results != null ? new LinkedHashSet<byte[]>(results) : null;
            }
        };
        BYTES_TO_STRING = new Converter<byte[], String>(){

            public String convert(byte[] source) {
                if (source == null || Arrays.equals(source, new byte[0])) {
                    return null;
                }
                return new String(source);
            }
        };
        STRING_TO_BYTES = new Converter<String, byte[]>(){

            public byte[] convert(String source) {
                if (source == null) {
                    return null;
                }
                return source.getBytes();
            }
        };
        BYTES_SET_TO_BYTES_LIST = new Converter<Set<byte[]>, List<byte[]>>(){

            public List<byte[]> convert(Set<byte[]> results) {
                return results != null ? new ArrayList<byte[]>(results) : null;
            }
        };
        KEY_VALUE_TO_BYTES_LIST = new Converter<KeyValue<byte[], byte[]>, List<byte[]>>(){

            public List<byte[]> convert(KeyValue<byte[], byte[]> source) {
                if (source == null) {
                    return null;
                }
                ArrayList<byte[]> list = new ArrayList<byte[]>(2);
                list.add((byte[])source.key);
                list.add((byte[])source.value);
                return list;
            }
        };
        BYTES_LIST_TO_MAP = new Converter<List<byte[]>, Map<byte[], byte[]>>(){

            public Map<byte[], byte[]> convert(List<byte[]> source) {
                if (CollectionUtils.isEmpty(source)) {
                    return Collections.emptyMap();
                }
                LinkedHashMap<byte[], byte[]> target = new LinkedHashMap<byte[], byte[]>();
                Iterator<byte[]> kv = source.iterator();
                while (kv.hasNext()) {
                    target.put(kv.next(), kv.hasNext() ? kv.next() : null);
                }
                return target;
            }
        };
        SCORED_VALUES_TO_TUPLE_SET = new Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>>(){

            public Set<RedisZSetCommands.Tuple> convert(List<ScoredValue<byte[]>> source) {
                if (source == null) {
                    return null;
                }
                LinkedHashSet<RedisZSetCommands.Tuple> tuples = new LinkedHashSet<RedisZSetCommands.Tuple>(source.size());
                for (ScoredValue<byte[]> value : source) {
                    tuples.add(LettuceConverters.toTuple(value));
                }
                return tuples;
            }
        };
        SCORED_VALUES_TO_TUPLE_LIST = new Converter<List<ScoredValue<byte[]>>, List<RedisZSetCommands.Tuple>>(){

            public List<RedisZSetCommands.Tuple> convert(List<ScoredValue<byte[]>> source) {
                if (source == null) {
                    return null;
                }
                ArrayList<RedisZSetCommands.Tuple> tuples = new ArrayList<RedisZSetCommands.Tuple>(source.size());
                for (ScoredValue<byte[]> value : source) {
                    tuples.add(LettuceConverters.toTuple(value));
                }
                return tuples;
            }
        };
        SCORED_VALUE_TO_TUPLE = new Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple>(){

            public RedisZSetCommands.Tuple convert(ScoredValue<byte[]> source) {
                return source != null ? new DefaultTuple((byte[])source.value, source.score) : null;
            }
        };
        BYTES_LIST_TO_TUPLE_LIST_CONVERTER = new Converter<List<byte[]>, List<RedisZSetCommands.Tuple>>(){

            public List<RedisZSetCommands.Tuple> convert(List<byte[]> source) {
                if (CollectionUtils.isEmpty(source)) {
                    return Collections.emptyList();
                }
                ArrayList<RedisZSetCommands.Tuple> tuples = new ArrayList<RedisZSetCommands.Tuple>();
                Iterator<byte[]> it = source.iterator();
                while (it.hasNext()) {
                    tuples.add(new DefaultTuple(it.next(), it.hasNext() ? Double.valueOf(LettuceConverters.toString(it.next())) : null));
                }
                return tuples;
            }
        };
        PARTITIONS_TO_CLUSTER_NODES = new Converter<Partitions, List<RedisClusterNode>>(){

            public List<RedisClusterNode> convert(Partitions source) {
                if (source == null) {
                    return Collections.emptyList();
                }
                ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>();
                for (com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode node : source.getPartitions()) {
                    nodes.add((RedisClusterNode)CLUSTER_NODE_TO_CLUSTER_NODE_CONVERTER.convert((Object)node));
                }
                return nodes;
            }
        };
        CLUSTER_NODE_TO_CLUSTER_NODE_CONVERTER = new Converter<com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode, RedisClusterNode>(){

            public RedisClusterNode convert(com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode source) {
                Set<RedisClusterNode.Flag> flags = this.parseFlags(source.getFlags());
                return RedisClusterNode.newRedisClusterNode().listeningAt(source.getUri().getHost(), source.getUri().getPort()).withId(source.getNodeId()).promotedAs(flags.contains((Object)RedisClusterNode.Flag.MASTER) ? RedisNode.NodeType.MASTER : RedisNode.NodeType.SLAVE).serving(new RedisClusterNode.SlotRange(source.getSlots())).withFlags(flags).linkState(source.isConnected() ? RedisClusterNode.LinkState.CONNECTED : RedisClusterNode.LinkState.DISCONNECTED).slaveOf(source.getSlaveOf()).build();
            }

            private Set<RedisClusterNode.Flag> parseFlags(Set<RedisClusterNode.NodeFlag> source) {
                LinkedHashSet<RedisClusterNode.Flag> flags = new LinkedHashSet<RedisClusterNode.Flag>(source != null ? source.size() : 8, 1.0f);
                for (RedisClusterNode.NodeFlag flag : source) {
                    switch (flag) {
                        case NOFLAGS: {
                            flags.add(RedisClusterNode.Flag.NOFLAGS);
                            break;
                        }
                        case EVENTUAL_FAIL: {
                            flags.add(RedisClusterNode.Flag.PFAIL);
                            break;
                        }
                        case FAIL: {
                            flags.add(RedisClusterNode.Flag.FAIL);
                            break;
                        }
                        case HANDSHAKE: {
                            flags.add(RedisClusterNode.Flag.HANDSHAKE);
                            break;
                        }
                        case MASTER: {
                            flags.add(RedisClusterNode.Flag.MASTER);
                            break;
                        }
                        case MYSELF: {
                            flags.add(RedisClusterNode.Flag.MYSELF);
                            break;
                        }
                        case NOADDR: {
                            flags.add(RedisClusterNode.Flag.NOADDR);
                            break;
                        }
                        case SLAVE: {
                            flags.add(RedisClusterNode.Flag.SLAVE);
                        }
                    }
                }
                return flags;
            }
        };
        PLUS_BYTES = LettuceConverters.toBytes("+");
        MINUS_BYTES = LettuceConverters.toBytes("-");
        POSITIVE_INFINITY_BYTES = LettuceConverters.toBytes("+inf");
        NEGATIVE_INFINITY_BYTES = LettuceConverters.toBytes("-inf");
        BYTES_LIST_TO_TIME_CONVERTER = new Converter<List<byte[]>, Long>(){

            public Long convert(List<byte[]> source) {
                Assert.notEmpty(source, (String)"Received invalid result from server. Expected 2 items in collection.");
                Assert.isTrue((source.size() == 2 ? 1 : 0) != 0, (String)("Received invalid nr of arguments from redis server. Expected 2 received " + source.size()));
                return Converters.toTimeMillis(LettuceConverters.toString(source.get(0)), LettuceConverters.toString(source.get(1)));
            }
        };
    }
}

