/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.data.redis.hash.HashMapper;

public class JacksonHashMapper<T>
implements HashMapper<T, String, Object> {
    private final ObjectMapper mapper;
    private final JavaType userType;
    private final JavaType mapType = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);

    public JacksonHashMapper(Class<T> type) {
        this(type, new ObjectMapper());
    }

    public JacksonHashMapper(Class<T> type, ObjectMapper mapper) {
        this.mapper = mapper;
        this.userType = TypeFactory.defaultInstance().constructType(type);
    }

    @Override
    public T fromHash(Map<String, Object> hash) {
        return (T)this.mapper.convertValue(hash, this.userType);
    }

    @Override
    public Map<String, Object> toHash(T object) {
        return (Map)this.mapper.convertValue(object, this.mapType);
    }
}

