/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.redis.hash.HashMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratingStringHashMapper<T>
implements HashMapper<T, String, String> {
    private final HashMapper<T, String, String> delegate;

    public DecoratingStringHashMapper(HashMapper<T, String, String> mapper) {
        this.delegate = mapper;
    }

    @Override
    public T fromHash(Map<String, String> hash) {
        return this.delegate.fromHash(hash);
    }

    @Override
    public Map<String, String> toHash(T object) {
        Map<String, String> hash = this.delegate.toHash(object);
        LinkedHashMap<String, String> flatten = new LinkedHashMap<String, String>(hash.size());
        for (Map.Entry<String, String> entry : hash.entrySet()) {
            flatten.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return flatten;
    }
}

