/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisException;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.channel.ChannelException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.RedisSystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LettuceExceptionConverter
implements Converter<Exception, DataAccessException> {
    public DataAccessException convert(Exception ex) {
        if (ex instanceof DataAccessException) {
            return (DataAccessException)ex;
        }
        if (ex instanceof RedisCommandInterruptedException) {
            return new RedisSystemException("Redis command interrupted", ex);
        }
        if (ex instanceof RedisException) {
            return new RedisSystemException("Redis exception", ex);
        }
        if (ex instanceof ChannelException) {
            return new RedisConnectionFailureException("Redis connection failed", ex);
        }
        if (ex instanceof TimeoutException) {
            return new QueryTimeoutException("Redis command timed out", (Throwable)ex);
        }
        return new RedisSystemException("Unknown Lettuce exception", ex);
    }
}

