/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.serializer.RedisSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializationUtils {
    static final byte[] EMPTY_ARRAY = new byte[0];

    static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    static <T extends Collection<?>> T deserializeValues(Collection<byte[]> rawValues, Class<T> type, RedisSerializer<?> redisSerializer) {
        if (rawValues == null) {
            return null;
        }
        AbstractCollection values = List.class.isAssignableFrom(type) ? new ArrayList(rawValues.size()) : new LinkedHashSet(rawValues.size());
        for (byte[] bs : rawValues) {
            values.add(redisSerializer.deserialize(bs));
        }
        return (T)values;
    }

    public static <T> Set<T> deserialize(Set<byte[]> rawValues, RedisSerializer<T> redisSerializer) {
        return SerializationUtils.deserializeValues(rawValues, Set.class, redisSerializer);
    }

    public static <T> List<T> deserialize(List<byte[]> rawValues, RedisSerializer<T> redisSerializer) {
        return SerializationUtils.deserializeValues(rawValues, List.class, redisSerializer);
    }

    public static <T> Collection<T> deserialize(Collection<byte[]> rawValues, RedisSerializer<T> redisSerializer) {
        return SerializationUtils.deserializeValues(rawValues, List.class, redisSerializer);
    }

    public static <T> Map<T, T> deserialize(Map<byte[], byte[]> rawValues, RedisSerializer<T> redisSerializer) {
        if (rawValues == null) {
            return null;
        }
        LinkedHashMap<T, T> ret = new LinkedHashMap<T, T>(rawValues.size());
        for (Map.Entry<byte[], byte[]> entry : rawValues.entrySet()) {
            ret.put(redisSerializer.deserialize(entry.getKey()), redisSerializer.deserialize(entry.getValue()));
        }
        return ret;
    }

    public static <HK, HV> Map<HK, HV> deserialize(Map<byte[], byte[]> rawValues, RedisSerializer<HK> hashKeySerializer, RedisSerializer<HV> hashValueSerializer) {
        if (rawValues == null) {
            return null;
        }
        LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>(rawValues.size());
        for (Map.Entry<byte[], byte[]> entry : rawValues.entrySet()) {
            byte[] key = hashKeySerializer != null ? (Object)hashKeySerializer.deserialize(entry.getKey()) : entry.getKey();
            byte[] value = hashValueSerializer != null ? (Object)hashValueSerializer.deserialize(entry.getValue()) : entry.getValue();
            map.put(key, value);
        }
        return map;
    }
}

