/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import org.jredis.ClientRuntimeException;
import org.jredis.JRedis;
import org.jredis.connector.Connection;
import org.jredis.connector.ConnectionSpec;
import org.jredis.ri.alphazero.JRedisClient;
import org.jredis.ri.alphazero.connection.DefaultConnectionSpec;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.Pool;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jredis.JredisConnection;
import org.springframework.data.redis.connection.jredis.JredisUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JredisConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory {
    private ConnectionSpec connectionSpec;
    private String hostName = "localhost";
    private int port = 6379;
    private String password = null;
    private int timeout;
    private int dbIndex = 0;
    private Pool<JRedis> pool;
    private static final int DEFAULT_REDIS_PORT = 6379;
    private static final int DEFAULT_REDIS_DB = 0;
    private static final byte[] DEFAULT_REDIS_PASSWORD = null;

    public JredisConnectionFactory() {
    }

    public JredisConnectionFactory(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public JredisConnectionFactory(Pool<JRedis> pool) {
        this.pool = pool;
    }

    public void afterPropertiesSet() {
        if (this.connectionSpec == null && this.pool == null) {
            Assert.hasText((String)this.hostName);
            this.connectionSpec = DefaultConnectionSpec.newSpec((String)this.hostName, (int)this.port, (int)this.dbIndex, (byte[])DEFAULT_REDIS_PASSWORD);
            this.connectionSpec.setConnectionFlag(Connection.Flag.RELIABLE, Boolean.valueOf(false));
            if (StringUtils.hasLength((String)this.password)) {
                this.connectionSpec.setCredentials(this.password);
            }
            if (this.timeout > 0) {
                this.connectionSpec.setSocketProperty(Connection.Socket.Property.SO_TIMEOUT, Integer.valueOf(this.timeout));
            }
        }
    }

    public void destroy() throws Exception {
        if (this.pool != null) {
            this.pool.destroy();
            this.pool = null;
        }
    }

    @Override
    public RedisConnection getConnection() {
        JredisConnection connection = this.pool != null ? new JredisConnection(this.pool.getResource(), this.pool) : new JredisConnection((JRedis)new JRedisClient(this.connectionSpec), null);
        return this.postProcessConnection(connection);
    }

    protected RedisConnection postProcessConnection(JredisConnection connection) {
        return connection;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof ClientRuntimeException) {
            return JredisUtils.convertJredisAccessException((ClientRuntimeException)ex);
        }
        return null;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }
}

