/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.support.collections.RedisMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRedisMap<K, V>
implements RedisMap<K, V> {
    private final BoundHashOperations<String, K, V> hashOps;

    public DefaultRedisMap(String key, RedisOperations<String, ?> operations) {
        this.hashOps = operations.boundHashOps(key);
    }

    public DefaultRedisMap(BoundHashOperations<String, K, V> boundOps) {
        this.hashOps = boundOps;
    }

    @Override
    public Long increment(K key, long delta) {
        return this.hashOps.increment(key, delta);
    }

    @Override
    public RedisOperations<String, ?> getOperations() {
        return this.hashOps.getOperations();
    }

    @Override
    public void clear() {
        this.getOperations().delete(Collections.singleton(this.getKey()));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashOps.hasKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<K> keySet = this.keySet();
        Collection<V> multiGet = this.hashOps.multiGet(keySet);
        Iterator<K> keys = keySet.iterator();
        Iterator<V> values = multiGet.iterator();
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        while (keys.hasNext()) {
            entries.add(new DefaultRedisMapEntry(keys.next(), values.next()));
        }
        return entries;
    }

    @Override
    public V get(Object key) {
        return this.hashOps.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.hashOps.keys();
    }

    @Override
    public V put(K key, V value) {
        V oldV = this.get(key);
        this.hashOps.put(key, value);
        return oldV;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.hashOps.putAll(m);
    }

    @Override
    public V remove(Object key) {
        V v = this.get(key);
        this.hashOps.delete(key);
        return v;
    }

    @Override
    public int size() {
        return this.hashOps.size().intValue();
    }

    @Override
    public Collection<V> values() {
        return this.hashOps.values();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RedisMap) {
            return o.hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 17 + this.getClass().hashCode();
        result = result * 31 + this.getKey().hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RedisStore for key:");
        sb.append(this.getKey());
        return sb.toString();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.hashOps.putIfAbsent(key, value) != false ? null : (V)this.get(key);
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean expire(long timeout, TimeUnit unit) {
        return this.hashOps.expire(timeout, unit);
    }

    @Override
    public Boolean expireAt(Date date) {
        return this.hashOps.expireAt(date);
    }

    @Override
    public Long getExpire() {
        return this.hashOps.getExpire();
    }

    @Override
    public Boolean persist() {
        return this.hashOps.persist();
    }

    @Override
    public String getKey() {
        return (String)this.hashOps.getKey();
    }

    @Override
    public void rename(String newKey) {
        this.hashOps.rename(newKey);
    }

    @Override
    public DataType getType() {
        return this.hashOps.getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultRedisMapEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public DefaultRedisMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

