/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;
import redis.clients.jedis.BinaryJedisPubSub;

class JedisSubscription
extends AbstractSubscription {
    private final BinaryJedisPubSub jedisPubSub;

    JedisSubscription(MessageListener listener, BinaryJedisPubSub jedisPubSub, byte[][] channels, byte[][] patterns) {
        super(listener, channels, patterns);
        this.jedisPubSub = jedisPubSub;
    }

    protected void doClose() {
        this.jedisPubSub.unsubscribe();
        this.jedisPubSub.punsubscribe();
    }

    protected void doPsubscribe(byte[] ... patterns) {
        this.jedisPubSub.psubscribe(patterns);
    }

    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        if (all) {
            this.jedisPubSub.punsubscribe();
        } else {
            this.jedisPubSub.punsubscribe(patterns);
        }
    }

    protected void doSubscribe(byte[] ... channels) {
        this.jedisPubSub.subscribe(channels);
    }

    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        if (all) {
            this.jedisPubSub.unsubscribe();
        } else {
            this.jedisPubSub.unsubscribe(channels);
        }
    }
}

