/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import org.reactivestreams.Publisher;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.repository.query.R2dbcParameterAccessor;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryExecution;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.r2dbc.core.FetchSpec;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.RowsFetchSpec;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public abstract class AbstractR2dbcQuery
implements RepositoryQuery {
    private final R2dbcQueryMethod method;
    private final R2dbcEntityOperations entityOperations;
    private final R2dbcConverter converter;
    private final EntityInstantiators instantiators;

    public AbstractR2dbcQuery(R2dbcQueryMethod method, R2dbcEntityOperations entityOperations, R2dbcConverter converter) {
        Assert.notNull((Object)((Object)method), (String)"R2dbcQueryMethod must not be null");
        Assert.notNull((Object)entityOperations, (String)"R2dbcEntityOperations must not be null");
        Assert.notNull((Object)converter, (String)"R2dbcConverter must not be null");
        this.method = method;
        this.entityOperations = entityOperations;
        this.converter = converter;
        this.instantiators = new EntityInstantiators();
    }

    public R2dbcQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        Mono<R2dbcParameterAccessor> resolveParameters = new R2dbcParameterAccessor(this.method, parameters).resolveParameters();
        return resolveParameters.flatMapMany(it -> this.createQuery((RelationalParameterAccessor)it).flatMapMany(foo -> this.executeQuery((R2dbcParameterAccessor)((Object)it), (PreparedOperation<?>)foo)));
    }

    private Publisher<?> executeQuery(R2dbcParameterAccessor parameterAccessor, PreparedOperation<?> operation) {
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)parameterAccessor);
        Object fetchSpec = this.isModifyingQuery() ? this.entityOperations.getDatabaseClient().sql(operation).fetch() : (this.isExistsQuery() ? this.entityOperations.getDatabaseClient().sql(operation).map(row -> true) : this.entityOperations.query(operation, processor.getReturnedType().getDomainType(), this.resolveResultType(processor)));
        R2dbcQueryExecution.ResultProcessingExecution execution = new R2dbcQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(processor.getReturnedType()), new R2dbcQueryExecution.ResultProcessingConverter(processor, this.converter.getMappingContext(), this.instantiators));
        return execution.execute((RowsFetchSpec<Object>)fetchSpec);
    }

    Class<?> resolveResultType(ResultProcessor resultProcessor) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        if (returnedType.getReturnedType().isAssignableFrom(returnedType.getDomainType())) {
            return returnedType.getDomainType();
        }
        return returnedType.getReturnedType();
    }

    private R2dbcQueryExecution getExecutionToWrap(ReturnedType returnedType) {
        if (this.isModifyingQuery()) {
            return fetchSpec -> {
                Assert.isInstanceOf(FetchSpec.class, (Object)fetchSpec);
                FetchSpec fs = (FetchSpec)fetchSpec;
                if (Boolean.class.isAssignableFrom(returnedType.getReturnedType())) {
                    return fs.rowsUpdated().map(integer -> integer > 0L);
                }
                if (Number.class.isAssignableFrom(returnedType.getReturnedType())) {
                    return fs.rowsUpdated().map(count -> this.converter.getConversionService().convert(count, returnedType.getReturnedType()));
                }
                if (ReflectionUtils.isVoid((Class)returnedType.getReturnedType())) {
                    return fs.rowsUpdated().then();
                }
                return fs.rowsUpdated();
            };
        }
        if (this.isCountQuery()) {
            return fetchSpec -> fetchSpec.first().defaultIfEmpty((Object)0L);
        }
        if (this.isExistsQuery()) {
            return fetchSpec -> fetchSpec.first().defaultIfEmpty((Object)false);
        }
        if (this.method.isCollectionQuery()) {
            return RowsFetchSpec::all;
        }
        return RowsFetchSpec::one;
    }

    protected abstract boolean isModifyingQuery();

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract Mono<PreparedOperation<?>> createQuery(RelationalParameterAccessor var1);
}

