/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.dialect.BindTargetBinder;
import org.springframework.data.r2dbc.repository.query.AbstractR2dbcQuery;
import org.springframework.data.r2dbc.repository.query.DefaultR2dbcSpELExpressionEvaluator;
import org.springframework.data.r2dbc.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.r2dbc.repository.query.ExpressionQuery;
import org.springframework.data.r2dbc.repository.query.R2dbcQueryMethod;
import org.springframework.data.r2dbc.repository.query.R2dbcSpELExpressionEvaluator;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.r2dbc.core.PreparedOperation;
import org.springframework.r2dbc.core.binding.BindTarget;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class StringBasedR2dbcQuery
extends AbstractR2dbcQuery {
    private final ExpressionQuery expressionQuery;
    private final ExpressionEvaluatingParameterBinder binder;
    private final ExpressionParser expressionParser;
    private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;
    private final ExpressionDependencies expressionDependencies;
    private final ReactiveDataAccessStrategy dataAccessStrategy;

    public StringBasedR2dbcQuery(R2dbcQueryMethod queryMethod, R2dbcEntityOperations entityOperations, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, entityOperations, converter, dataAccessStrategy, expressionParser, evaluationContextProvider);
    }

    public StringBasedR2dbcQuery(String query, R2dbcQueryMethod method, R2dbcEntityOperations entityOperations, R2dbcConverter converter, ReactiveDataAccessStrategy dataAccessStrategy, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, entityOperations, converter);
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        Assert.hasText((String)query, (String)"Query must not be empty");
        this.dataAccessStrategy = dataAccessStrategy;
        this.expressionQuery = ExpressionQuery.create(query);
        this.binder = new ExpressionEvaluatingParameterBinder(this.expressionQuery, dataAccessStrategy);
        this.expressionDependencies = this.createExpressionDependencies();
        if (method.isSliceQuery()) {
            throw new UnsupportedOperationException("Slice queries are not supported using string-based queries; Offending method: " + String.valueOf((Object)method));
        }
        if (method.isPageQuery()) {
            throw new UnsupportedOperationException("Page queries are not supported using string-based queries; Offending method: " + String.valueOf((Object)method));
        }
        if (method.getParameters().hasLimitParameter()) {
            throw new UnsupportedOperationException("Queries with Limit are not supported using string-based queries; Offending method: " + String.valueOf((Object)method));
        }
    }

    private ExpressionDependencies createExpressionDependencies() {
        if (this.expressionQuery.getBindings().isEmpty()) {
            return ExpressionDependencies.none();
        }
        ArrayList<ExpressionDependencies> dependencies = new ArrayList<ExpressionDependencies>();
        for (ExpressionQuery.ParameterBinding binding : this.expressionQuery.getBindings()) {
            dependencies.add(ExpressionDependencies.discover((Expression)this.expressionParser.parseExpression(binding.getExpression())));
        }
        return ExpressionDependencies.merged(dependencies);
    }

    @Override
    protected boolean isModifyingQuery() {
        return this.getQueryMethod().isModifyingQuery();
    }

    @Override
    protected boolean isCountQuery() {
        return false;
    }

    @Override
    protected boolean isExistsQuery() {
        return false;
    }

    @Override
    protected Mono<PreparedOperation<?>> createQuery(RelationalParameterAccessor accessor) {
        return this.getSpelEvaluator(accessor).map(evaluator -> new ExpandedQuery(accessor, (R2dbcSpELExpressionEvaluator)evaluator));
    }

    @Override
    Class<?> resolveResultType(ResultProcessor resultProcessor) {
        Class<?> returnedType = resultProcessor.getReturnedType().getReturnedType();
        return !returnedType.isInterface() ? returnedType : super.resolveResultType(resultProcessor);
    }

    private Mono<R2dbcSpELExpressionEvaluator> getSpelEvaluator(RelationalParameterAccessor accessor) {
        return this.evaluationContextProvider.getEvaluationContextLater((Parameters)this.getQueryMethod().getParameters(), accessor.getValues(), this.expressionDependencies).map(context -> new DefaultR2dbcSpELExpressionEvaluator(this.expressionParser, (EvaluationContext)context)).defaultIfEmpty((Object)DefaultR2dbcSpELExpressionEvaluator.unsupported());
    }

    public String toString() {
        String sb = this.getClass().getSimpleName() + " [" + this.expressionQuery.getQuery() + "]";
        return sb;
    }

    private class ExpandedQuery
    implements PreparedOperation<String> {
        private final BindTargetRecorder recordedBindings = new BindTargetRecorder();
        private final PreparedOperation<?> expanded;
        private final Map<String, Parameter> remainderByName;
        private final Map<Integer, Parameter> remainderByIndex;

        public ExpandedQuery(RelationalParameterAccessor accessor, R2dbcSpELExpressionEvaluator evaluator) {
            StringBasedR2dbcQuery.this.binder.bind(this.recordedBindings, accessor, evaluator);
            this.remainderByName = new LinkedHashMap<String, Parameter>(this.recordedBindings.byName);
            this.remainderByIndex = new LinkedHashMap<Integer, Parameter>(this.recordedBindings.byIndex);
            this.expanded = StringBasedR2dbcQuery.this.dataAccessStrategy.processNamedParameters(StringBasedR2dbcQuery.this.expressionQuery.getQuery(), (index, name) -> {
                if (this.recordedBindings.byName.containsKey(name)) {
                    this.remainderByName.remove(name);
                    return this.recordedBindings.byName.get(name);
                }
                if (this.recordedBindings.byIndex.containsKey(index)) {
                    this.remainderByIndex.remove(index);
                    return this.recordedBindings.byIndex.get(index);
                }
                return null;
            });
        }

        public String getSource() {
            return StringBasedR2dbcQuery.this.expressionQuery.getQuery();
        }

        public void bindTo(BindTarget target) {
            BindTargetBinder binder = new BindTargetBinder(target);
            this.expanded.bindTo(target);
            this.remainderByName.forEach(binder::bind);
            this.remainderByIndex.forEach(binder::bind);
        }

        public String toQuery() {
            return this.expanded.toQuery();
        }

        public String toString() {
            return String.format("Original: [%s], Expanded: [%s]", StringBasedR2dbcQuery.this.expressionQuery.getQuery(), this.expanded.toQuery());
        }
    }

    private static class BindTargetRecorder
    implements BindTarget {
        final Map<Integer, Parameter> byIndex = new LinkedHashMap<Integer, Parameter>();
        final Map<String, Parameter> byName = new LinkedHashMap<String, Parameter>();

        private BindTargetRecorder() {
        }

        public void bind(String identifier, Object value) {
            this.byName.put(identifier, this.toParameter(value));
        }

        private Parameter toParameter(Object value) {
            return value instanceof Parameter ? (Parameter)value : Parameter.from((Object)value);
        }

        public void bind(int index, Object value) {
            this.byIndex.put(index, this.toParameter(value));
        }

        public void bindNull(String identifier, Class<?> type) {
            this.byName.put(identifier, Parameter.empty(type));
        }

        public void bindNull(int index, Class<?> type) {
            this.byIndex.put(index, Parameter.empty(type));
        }
    }
}

