/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.repository.query.SpelQueryContext;

class ExpressionQuery {
    private static final String SYNTHETIC_PARAMETER_TEMPLATE = "__synthetic_%d__";
    private final String query;
    private final List<ParameterBinding> parameterBindings;

    private ExpressionQuery(String query, List<ParameterBinding> parameterBindings) {
        this.query = query;
        this.parameterBindings = parameterBindings;
    }

    public static ExpressionQuery create(String query) {
        ArrayList<ParameterBinding> parameterBindings = new ArrayList<ParameterBinding>();
        SpelQueryContext queryContext = SpelQueryContext.of((counter, expression) -> {
            String parameterName = String.format(SYNTHETIC_PARAMETER_TEMPLATE, counter);
            parameterBindings.add(new ParameterBinding(parameterName, (String)expression));
            return parameterName;
        }, String::concat);
        SpelQueryContext.SpelExtractor parsed = queryContext.parse(query);
        return new ExpressionQuery(parsed.getQueryString(), parameterBindings);
    }

    public String getQuery() {
        return this.query;
    }

    public List<ParameterBinding> getBindings() {
        return this.parameterBindings;
    }

    public String toString() {
        return this.query;
    }

    static class ParameterBinding {
        private final String parameterName;
        private final String expression;

        private ParameterBinding(String parameterName, String expression) {
            this.expression = expression;
            this.parameterName = parameterName;
        }

        String getExpression() {
            return this.expression;
        }

        String getParameterName() {
            return this.parameterName;
        }
    }
}

