/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.Method;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

class RowMetadataUtils {
    @Nullable
    private static final Method getColumnMetadatas = ReflectionUtils.findMethod(RowMetadata.class, (String)"getColumnMetadatas");

    RowMetadataUtils() {
    }

    public static boolean containsColumn(RowMetadata metadata, String name) {
        Iterable<? extends ColumnMetadata> columns = RowMetadataUtils.getColumnMetadata(metadata);
        for (ColumnMetadata columnMetadata : columns) {
            if (!name.equalsIgnoreCase(columnMetadata.getName())) continue;
            return true;
        }
        return false;
    }

    public static Iterable<? extends ColumnMetadata> getColumnMetadata(RowMetadata metadata) {
        if (getColumnMetadatas != null) {
            return (Iterable)ReflectionUtils.invokeMethod((Method)getColumnMetadatas, (Object)metadata);
        }
        return metadata.getColumnMetadatas();
    }
}

