/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.lang.Nullable;

class RowPropertyAccessor
implements PropertyAccessor {
    @Nullable
    private final RowMetadata rowMetadata;

    RowPropertyAccessor(@Nullable RowMetadata rowMetadata) {
        this.rowMetadata = rowMetadata;
    }

    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Row.class};
    }

    public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
        return this.rowMetadata != null && target != null && this.rowMetadata.getColumnNames().contains(name);
    }

    public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
        if (target == null) {
            return TypedValue.NULL;
        }
        Object value = ((Row)target).get(name);
        if (value == null) {
            return TypedValue.NULL;
        }
        return new TypedValue(value);
    }

    public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object newValue) {
        throw new UnsupportedOperationException();
    }
}

