/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.convert.R2dbcConverters;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.R2dbcSimpleTypeHolder;

public class R2dbcCustomConversions
extends CustomConversions {
    public static final List<Object> STORE_CONVERTERS;
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public R2dbcCustomConversions(Collection<?> converters) {
        super((CustomConversions.ConverterConfiguration)new R2dbcCustomConversionsConfiguration(STORE_CONVERSIONS, R2dbcCustomConversions.appendOverrides(converters)));
    }

    public R2dbcCustomConversions(CustomConversions.StoreConversions storeConversions, Collection<?> converters) {
        super((CustomConversions.ConverterConfiguration)new R2dbcCustomConversionsConfiguration(storeConversions, R2dbcCustomConversions.appendOverrides(converters)));
    }

    public static R2dbcCustomConversions of(R2dbcDialect dialect, Object ... converters) {
        return R2dbcCustomConversions.of(dialect, Arrays.asList(converters));
    }

    public static R2dbcCustomConversions of(R2dbcDialect dialect, Collection<?> converters) {
        ArrayList<Object> storeConverters = new ArrayList<Object>(dialect.getConverters());
        storeConverters.addAll(STORE_CONVERTERS);
        return new R2dbcCustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)dialect.getSimpleTypeHolder(), storeConverters), converters);
    }

    private static List<?> appendOverrides(Collection<?> converters) {
        ArrayList objects = new ArrayList(converters);
        objects.addAll(R2dbcConverters.getOverrideConvertersToRegister());
        return objects;
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(R2dbcConverters.getConvertersToRegister());
        converters.addAll(JodaTimeConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)R2dbcSimpleTypeHolder.HOLDER, STORE_CONVERTERS);
    }

    static class R2dbcCustomConversionsConfiguration
    extends CustomConversions.ConverterConfiguration {
        public R2dbcCustomConversionsConfiguration(CustomConversions.StoreConversions storeConversions, List<?> userConverters) {
            super(storeConversions, userConverters, convertiblePair -> !convertiblePair.getSourceType().getName().startsWith("java.time.") || !convertiblePair.getTargetType().equals(Date.class));
        }
    }
}

