/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.r2dbc.dialect.H2Dialect;
import org.springframework.data.r2dbc.dialect.MySqlDialect;
import org.springframework.data.r2dbc.dialect.PostgresDialect;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.dialect.SqlServerDialect;
import org.springframework.data.util.Optionals;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class DialectResolver {
    private static final List<R2dbcDialectProvider> DETECTORS = SpringFactoriesLoader.loadFactories(R2dbcDialectProvider.class, (ClassLoader)DialectResolver.class.getClassLoader());

    private DialectResolver() {
    }

    public static R2dbcDialect getDialect(ConnectionFactory connectionFactory) {
        return (R2dbcDialect)DETECTORS.stream().map(it -> it.getDialect(connectionFactory)).flatMap(xva$0 -> Optionals.toStream((Optional[])new Optional[]{xva$0})).findFirst().orElseThrow(() -> new NoDialectException(String.format("Cannot determine a dialect for %s using %s. Please provide a Dialect.", connectionFactory.getMetadata().getName(), connectionFactory)));
    }

    static class BuiltInDialectProvider
    implements R2dbcDialectProvider {
        private static final Map<String, R2dbcDialect> BUILTIN = new LinkedCaseInsensitiveMap(Locale.ENGLISH);

        BuiltInDialectProvider() {
        }

        @Override
        public Optional<R2dbcDialect> getDialect(ConnectionFactory connectionFactory) {
            ConnectionFactoryMetadata metadata = connectionFactory.getMetadata();
            R2dbcDialect r2dbcDialect = BUILTIN.get(metadata.getName());
            if (r2dbcDialect != null) {
                return Optional.of(r2dbcDialect);
            }
            return BUILTIN.keySet().stream().filter(it -> metadata.getName().contains((CharSequence)it)).map(BUILTIN::get).findFirst();
        }

        static {
            BUILTIN.put("H2", H2Dialect.INSTANCE);
            BUILTIN.put("Microsoft SQL Server", SqlServerDialect.INSTANCE);
            BUILTIN.put("MySQL", MySqlDialect.INSTANCE);
            BUILTIN.put("MariaDB", MySqlDialect.INSTANCE);
            BUILTIN.put("PostgreSQL", PostgresDialect.INSTANCE);
        }
    }

    public static class NoDialectException
    extends NonTransientDataAccessException {
        public NoDialectException(String msg) {
            super(msg);
        }
    }

    public static interface R2dbcDialectProvider {
        public Optional<R2dbcDialect> getDialect(ConnectionFactory var1);
    }
}

