/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.core.R2dbcEntityOperations;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.repository.support.R2dbcRepositoryFactory;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.Assert;

public class R2dbcRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    @Nullable
    private DatabaseClient client;
    @Nullable
    private ReactiveDataAccessStrategy dataAccessStrategy;
    @Nullable
    private R2dbcEntityOperations operations;
    private boolean mappingContextConfigured = false;

    public R2dbcRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
        this.setEvaluationContextProvider((QueryMethodEvaluationContextProvider)ReactiveQueryMethodEvaluationContextProvider.DEFAULT);
    }

    public void setDatabaseClient(DatabaseClient client) {
        this.client = client;
    }

    public void setDataAccessStrategy(ReactiveDataAccessStrategy dataAccessStrategy) {
        this.dataAccessStrategy = dataAccessStrategy;
    }

    public void setEntityOperations(R2dbcEntityOperations operations) {
        this.operations = operations;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        this.mappingContextConfigured = true;
        super.setMappingContext(mappingContext);
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.operations != null ? this.getFactoryInstance(this.operations) : this.getFactoryInstance(this.client, this.dataAccessStrategy);
    }

    protected RepositoryFactorySupport getFactoryInstance(DatabaseClient client, ReactiveDataAccessStrategy dataAccessStrategy) {
        return new R2dbcRepositoryFactory(client, dataAccessStrategy);
    }

    protected RepositoryFactorySupport getFactoryInstance(R2dbcEntityOperations operations) {
        return new R2dbcRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        if (this.operations == null) {
            Assert.state((this.client != null ? 1 : 0) != 0, (String)"DatabaseClient must not be null when R2dbcEntityOperations is not configured!");
            Assert.state((this.dataAccessStrategy != null ? 1 : 0) != 0, (String)"ReactiveDataAccessStrategy must not be null when R2dbcEntityOperations is not configured!");
        } else {
            this.dataAccessStrategy = this.operations.getDataAccessStrategy();
        }
        if (!this.mappingContextConfigured) {
            this.setMappingContext(this.dataAccessStrategy.getConverter().getMappingContext());
        }
        super.afterPropertiesSet();
    }
}

