/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.query;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.Nullable;

class R2dbcQueryCreator
extends RelationalQueryCreator<PreparedOperation<?>> {
    private final PartTree tree;
    private final RelationalParameterAccessor accessor;
    private final ReactiveDataAccessStrategy dataAccessStrategy;
    private final RelationalEntityMetadata<?> entityMetadata;
    private final List<String> projectedProperties;

    public R2dbcQueryCreator(PartTree tree, ReactiveDataAccessStrategy dataAccessStrategy, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor, List<String> projectedProperties) {
        super(tree, accessor);
        this.tree = tree;
        this.accessor = accessor;
        this.dataAccessStrategy = dataAccessStrategy;
        this.entityMetadata = entityMetadata;
        this.projectedProperties = projectedProperties;
    }

    protected PreparedOperation<?> complete(@Nullable Criteria criteria, Sort sort) {
        StatementMapper.TypedStatementMapper statementMapper = this.dataAccessStrategy.getStatementMapper().forType(this.entityMetadata.getJavaType());
        if (this.tree.isDelete()) {
            return this.delete(criteria, statementMapper);
        }
        return this.select(criteria, sort, statementMapper);
    }

    private PreparedOperation<?> delete(@Nullable Criteria criteria, StatementMapper statementMapper) {
        StatementMapper.DeleteSpec deleteSpec = statementMapper.createDelete(this.entityMetadata.getTableName()).withCriteria((CriteriaDefinition)criteria);
        return statementMapper.getMappedObject(deleteSpec);
    }

    private PreparedOperation<?> select(@Nullable Criteria criteria, Sort sort, StatementMapper statementMapper) {
        StatementMapper.SelectSpec selectSpec = statementMapper.createSelect(this.entityMetadata.getTableName()).withProjection(this.getSelectProjection());
        if (this.tree.isExistsProjection()) {
            selectSpec = selectSpec.limit(1);
        } else if (this.tree.isLimiting()) {
            selectSpec = selectSpec.limit(this.tree.getMaxResults());
        }
        Pageable pageable = this.accessor.getPageable();
        if (pageable.isPaged()) {
            selectSpec = selectSpec.limit(pageable.getPageSize()).offset(pageable.getOffset());
        }
        if (criteria != null) {
            selectSpec = selectSpec.withCriteria((CriteriaDefinition)criteria);
        }
        if (sort.isSorted()) {
            selectSpec = selectSpec.withSort(this.getSort(sort));
        }
        if (this.tree.isDistinct()) {
            selectSpec = selectSpec.distinct();
        }
        return statementMapper.getMappedObject(selectSpec);
    }

    private SqlIdentifier[] getSelectProjection() {
        List<Object> columnNames;
        if (!this.projectedProperties.isEmpty()) {
            RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
            columnNames = new ArrayList(this.projectedProperties.size());
            for (String projectedProperty : this.projectedProperties) {
                RelationalPersistentProperty property = (RelationalPersistentProperty)entity.getPersistentProperty(projectedProperty);
                columnNames.add(property != null ? property.getColumnName() : SqlIdentifier.unquoted((String)projectedProperty));
            }
        } else {
            columnNames = this.tree.isExistsProjection() ? this.dataAccessStrategy.getIdentifierColumns(this.entityMetadata.getJavaType()) : this.dataAccessStrategy.getAllColumns(this.entityMetadata.getJavaType());
        }
        return columnNames.toArray(new SqlIdentifier[0]);
    }

    private Sort getSort(Sort sort) {
        RelationalPersistentEntity tableEntity = this.entityMetadata.getTableEntity();
        List orders = sort.get().map(order -> {
            RelationalPersistentProperty property = (RelationalPersistentProperty)tableEntity.getRequiredPersistentProperty(order.getProperty());
            return order.isAscending() ? Sort.Order.asc((String)property.getName()) : Sort.Order.desc((String)property.getName());
        }).collect(Collectors.toList());
        return Sort.by(orders);
    }
}

