/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.xdb.XMLType;
import org.springframework.jdbc.support.xml.SqlXmlValue;
import org.w3c.dom.Document;

public class OracleXmlTypeValue
implements SqlXmlValue {
    private static final int STRING = 0;
    private static final int STREAM = 1;
    private static final int DOCUMENT = 2;
    private int inputType = 0;
    private String value;
    private Document doc;
    private InputStream stream;
    private XMLType xmlValue;

    public OracleXmlTypeValue(String value) {
        this.value = value;
        this.inputType = 0;
    }

    public OracleXmlTypeValue(InputStream stream) {
        this.stream = stream;
        this.inputType = 1;
    }

    public OracleXmlTypeValue(Document doc) {
        this.doc = doc;
        this.inputType = 2;
    }

    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        Connection conn = ps.getConnection();
        switch (this.inputType) {
            case 0: {
                this.xmlValue = XMLType.createXML((Connection)conn, (String)this.value);
                break;
            }
            case 1: {
                this.xmlValue = XMLType.createXML((Connection)conn, (InputStream)this.stream);
                break;
            }
            case 2: {
                this.xmlValue = XMLType.createXML((Connection)conn, (Document)this.doc);
            }
        }
        ps.setObject(paramIndex, (Object)this.xmlValue, 2007);
    }

    public void cleanup() {
        if (this.xmlValue != null) {
            this.xmlValue.close();
        }
    }
}

