/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jdbc.support.oracle.OracleXmlHandler;
import org.springframework.data.jdbc.support.oracle.OracleXmlTypeMarshallingValue;
import org.springframework.jdbc.support.xml.SqlXmlObjectMappingHandler;
import org.springframework.jdbc.support.xml.SqlXmlValue;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.UnmarshallingFailureException;

public class OracleXmlObjectMappingHandler
extends OracleXmlHandler
implements SqlXmlObjectMappingHandler {
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public Object getXmlAsObject(ResultSet rs, String columnName) throws SQLException {
        Object o;
        String xml = this.getXmlAsString(rs, columnName);
        try {
            o = this.doUnmarshall(xml);
        }
        catch (IOException e) {
            throw new UnmarshallingFailureException("Error unmarshalling xml data from '" + columnName + "'  column: ", (Throwable)e);
        }
        return o;
    }

    public Object getXmlAsObject(ResultSet rs, int columnIndex) throws SQLException {
        Object o;
        String xml = this.getXmlAsString(rs, columnIndex);
        try {
            o = this.doUnmarshall(xml);
        }
        catch (IOException e) {
            throw new UnmarshallingFailureException("Error unmarshalling xml data from column " + columnIndex + ": ", (Throwable)e);
        }
        return o;
    }

    public SqlXmlValue newMarshallingSqlXmlValue(Object value) {
        if (this.marshaller == null) {
            throw new InvalidDataAccessApiUsageException("Marshalling requires that a Marshaller is configured");
        }
        return new OracleXmlTypeMarshallingValue(value, this.marshaller);
    }

    private Object doUnmarshall(String xml) throws IOException {
        if (this.unmarshaller == null) {
            throw new InvalidDataAccessApiUsageException("Unmarshalling requires that an Unmarshaller is configured");
        }
        return this.unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xml)));
    }
}

