/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;
import org.springframework.data.jdbc.support.oracle.OracleXmlTypeValue;
import org.springframework.jdbc.support.xml.SqlXmlFeatureNotImplementedException;
import org.springframework.jdbc.support.xml.SqlXmlHandler;
import org.springframework.jdbc.support.xml.SqlXmlValue;
import org.springframework.jdbc.support.xml.XmlBinaryStreamProvider;
import org.springframework.jdbc.support.xml.XmlCharacterStreamProvider;
import org.springframework.jdbc.support.xml.XmlResultProvider;
import org.w3c.dom.Document;

public class OracleXmlHandler
implements SqlXmlHandler {
    public String getXmlAsString(ResultSet rs, String columnName) throws SQLException {
        XMLType oxml = (XMLType)rs.getObject(columnName);
        String value = oxml.getStringVal();
        oxml.close();
        return value;
    }

    public String getXmlAsString(ResultSet rs, int columnIndex) throws SQLException {
        XMLType oxml = (XMLType)rs.getObject(columnIndex);
        String value = oxml.getStringVal();
        oxml.close();
        return value;
    }

    public InputStream getXmlAsBinaryStream(final ResultSet rs, final String columnName) throws SQLException {
        return this.doGetXmlAsBinaryStream(new XmlTypeProvider(){

            @Override
            public XMLType getXmlType() throws SQLException {
                return (XMLType)rs.getObject(columnName);
            }
        }, rs.getStatement().getConnection());
    }

    public InputStream getXmlAsBinaryStream(final ResultSet rs, final int columnIndex) throws SQLException {
        return this.doGetXmlAsBinaryStream(new XmlTypeProvider(){

            @Override
            public XMLType getXmlType() throws SQLException {
                return (XMLType)rs.getObject(columnIndex);
            }
        }, rs.getStatement().getConnection());
    }

    private InputStream doGetXmlAsBinaryStream(XmlTypeProvider provider, Connection conn) throws SQLException {
        if (XMLType.getConnType((Connection)conn) == 0) {
            throw new SqlXmlFeatureNotImplementedException("getXmlAsBinaryStream method is not implemented for the \"thin\" driver");
        }
        XMLType oxml = provider.getXmlType();
        InputStream is = oxml.getInputStream();
        oxml.close();
        return is;
    }

    public Reader getXmlAsCharacterStream(ResultSet rs, String columnName) throws SQLException {
        throw new SqlXmlFeatureNotImplementedException("getXmlAsCharacterStream method is not implemented yet");
    }

    public Reader getXmlAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        throw new SqlXmlFeatureNotImplementedException("getXmlAsCharacterStream method is not implemented yet");
    }

    public Source getXmlAsSource(final ResultSet rs, final String columnName, Class sourceClass) throws SQLException {
        return this.doGetXmlAsSource(new XmlTypeProvider(){

            @Override
            public XMLType getXmlType() throws SQLException {
                return (XMLType)rs.getObject(columnName);
            }
        }, rs.getStatement().getConnection(), sourceClass);
    }

    public Source getXmlAsSource(final ResultSet rs, final int columnIndex, Class sourceClass) throws SQLException {
        return this.doGetXmlAsSource(new XmlTypeProvider(){

            @Override
            public XMLType getXmlType() throws SQLException {
                return (XMLType)rs.getObject(columnIndex);
            }
        }, rs.getStatement().getConnection(), sourceClass);
    }

    private Source doGetXmlAsSource(XmlTypeProvider provider, Connection conn, Class sourceClass) throws SQLException, SqlXmlFeatureNotImplementedException {
        Class sourceClassToUse;
        int connType = XMLType.getConnType((Connection)conn);
        if (sourceClass == null) {
            sourceClassToUse = connType == 0 ? DOMSource.class : StreamSource.class;
        } else {
            if (connType == 0 ? !sourceClass.equals(DOMSource.class) : !sourceClass.equals(DOMSource.class) && !sourceClass.equals(StreamSource.class)) {
                throw new SqlXmlFeatureNotImplementedException("getXmlAsSource method does not support a source class of " + sourceClass.getName());
            }
            sourceClassToUse = sourceClass;
        }
        Source source = null;
        XMLType oxml = provider.getXmlType();
        if (sourceClassToUse.equals(DOMSource.class)) {
            Document doc;
            if (connType == 0) {
                doc = oxml.getDocument();
            } else {
                XMLType xt = XMLType.createXML((OPAQUE)oxml, (String)"oracle.xml.parser.XMLDocument.THIN");
                doc = xt.getDocument();
            }
            source = new DOMSource(doc);
        } else if (sourceClassToUse.equals(StreamSource.class)) {
            InputStream is = oxml.getInputStream();
            source = new StreamSource(is);
        }
        return source;
    }

    public SqlXmlValue newSqlXmlValue(String value) {
        return new OracleXmlTypeValue(value);
    }

    public SqlXmlValue newSqlXmlValue(XmlBinaryStreamProvider provider) {
        throw new SqlXmlFeatureNotImplementedException("newSqlXmlValue method is not implemented yet");
    }

    public SqlXmlValue newSqlXmlValue(XmlCharacterStreamProvider provider) {
        throw new SqlXmlFeatureNotImplementedException("newSqlXmlValue method is not implemented yet");
    }

    public SqlXmlValue newSqlXmlValue(Class resultClass, XmlResultProvider xmlResultProvider) {
        throw new SqlXmlFeatureNotImplementedException("newSqlXmlValue method is not implemented yet");
    }

    public SqlXmlValue newSqlXmlValue(Document document) {
        return new OracleXmlTypeValue(document);
    }

    private static interface XmlTypeProvider {
        public XMLType getXmlType() throws SQLException;
    }
}

