/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.jms.support.converter.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsSession;
import oracle.jms.AdtMessage;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.STRUCT;
import org.springframework.data.jdbc.jms.support.oracle.DatumMapper;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;

public class MappingAdtMessageConverter
implements MessageConverter {
    private DatumMapper mapper;

    public MappingAdtMessageConverter(DatumMapper mapper) {
        this.mapper = mapper;
    }

    protected DatumMapper getMapper() {
        return this.mapper;
    }

    public Message toMessage(final Object object, Session session) throws JMSException, MessageConversionException {
        AdtMessage message = ((AQjmsSession)session).createAdtMessage();
        message.setAdtPayload(new ORAData(){

            public Datum toDatum(Connection conn) throws SQLException {
                return MappingAdtMessageConverter.this.getMapper().toDatum(object, conn);
            }
        });
        return message;
    }

    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        AQjmsAdtMessage aqMessage = (AQjmsAdtMessage)message;
        Object result = null;
        ORAData data = (ORAData)aqMessage.getAdtPayload();
        try {
            STRUCT struct = (STRUCT)data.toDatum(null);
            result = this.getMapper().fromDatum((Datum)struct);
        }
        catch (SQLException sqle) {
            throw new MessageConversionException("Error while accessing ADT payload", (Throwable)sqle);
        }
        return result;
    }
}

