/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.IsoDuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.neo4j.core.convert.TemporalAmountAdapter;

final class TemporalAmountConverter
implements GenericConverter {
    private final TemporalAmountAdapter adapter = new TemporalAmountAdapter();
    private final Set<GenericConverter.ConvertiblePair> convertibleTypes = Collections.unmodifiableSet(new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(new GenericConverter.ConvertiblePair(Value.class, TemporalAmount.class), new GenericConverter.ConvertiblePair(TemporalAmount.class, Value.class))));

    TemporalAmountConverter() {
    }

    private static boolean isZero(IsoDuration isoDuration) {
        return isoDuration.months() == 0L && isoDuration.days() == 0L && isoDuration.seconds() == 0L && (long)isoDuration.nanoseconds() == 0L;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertibleTypes;
    }

    public @Nullable Object convert(@Nullable Object value, TypeDescriptor sourceType, TypeDescriptor targetType) {
        TemporalAmount convertedValue;
        if (TemporalAmount.class.isAssignableFrom(sourceType.getType())) {
            return Values.value((Object)value);
        }
        TemporalAmount temporalAmount = convertedValue = value == null || value == Values.NULL ? null : this.adapter.apply((TemporalAmount)((Value)value).asIsoDuration());
        if (convertedValue instanceof IsoDuration && TemporalAmountConverter.isZero((IsoDuration)convertedValue)) {
            if (Period.class.isAssignableFrom(targetType.getType())) {
                return Period.of(0, 0, 0);
            }
            if (Duration.class.isAssignableFrom(targetType.getType())) {
                return Duration.ZERO;
            }
        }
        return convertedValue;
    }
}

