/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.KPropertyFilterSupport;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;

@API(status=API.Status.INTERNAL, since="6.1.3")
public final class PropertyFilterSupport {
    private static final AggregateBoundaries AGGREGATE_BOUNDARIES = new AggregateBoundaries();

    private PropertyFilterSupport() {
    }

    public static Collection<PropertyFilter.ProjectedPath> getInputProperties(ResultProcessor resultProcessor, ProjectionFactory factory, Neo4jMappingContext mappingContext) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        Class potentiallyProjectedType = returnedType.getReturnedType();
        Class domainType = returnedType.getDomainType();
        HashSet<PropertyFilter.ProjectedPath> filteredProperties = new HashSet<PropertyFilter.ProjectedPath>();
        boolean isProjecting = returnedType.isProjecting();
        boolean isClosedProjection = factory.getProjectionInformation(potentiallyProjectedType).isClosed();
        if (!isProjecting && PropertyFilterSupport.containsAggregateBoundary(domainType, mappingContext)) {
            Collection<PropertyFilter.ProjectedPath> listForAggregate = PropertyFilterSupport.createListForAggregate(domainType, mappingContext);
            return listForAggregate;
        }
        if (!isProjecting || !isClosedProjection) {
            return Collections.emptySet();
        }
        for (String inputProperty : returnedType.getInputProperties()) {
            PropertyFilterSupport.addPropertiesFrom(domainType, potentiallyProjectedType, factory, filteredProperties, new ProjectionPathProcessor(inputProperty, PropertyPath.from((String)inputProperty, (Class)potentiallyProjectedType).getLeafProperty().getTypeInformation()), mappingContext);
        }
        for (String inputProperty : KPropertyFilterSupport.getRequiredProperties(domainType)) {
            PropertyFilterSupport.addPropertiesFrom(domainType, potentiallyProjectedType, factory, filteredProperties, new ProjectionPathProcessor(inputProperty, PropertyPath.from((String)inputProperty, (Class)domainType).getLeafProperty().getTypeInformation()), mappingContext);
        }
        return filteredProperties;
    }

    public static Collection<PropertyFilter.ProjectedPath> getInputPropertiesForAggregateBoundary(Class<?> domainType, Neo4jMappingContext mappingContext) {
        if (!PropertyFilterSupport.containsAggregateBoundary(domainType, mappingContext)) {
            return Collections.emptySet();
        }
        Collection<PropertyFilter.ProjectedPath> listForAggregate = PropertyFilterSupport.createListForAggregate(domainType, mappingContext);
        return listForAggregate;
    }

    public static Predicate<PropertyFilter.RelaxedPropertyPath> createRelaxedPropertyPathFilter(Class<?> domainType, Neo4jMappingContext mappingContext) {
        if (!PropertyFilterSupport.containsAggregateBoundary(domainType, mappingContext)) {
            return PropertyFilter.NO_FILTER;
        }
        Collection<PropertyFilter.RelaxedPropertyPath> relaxedPropertyPathFilter = PropertyFilterSupport.createRelaxedPropertyPathFilter(domainType, mappingContext, new HashSet<RelationshipDescription>());
        return rpp -> relaxedPropertyPathFilter.contains(rpp);
    }

    private static Collection<PropertyFilter.RelaxedPropertyPath> createRelaxedPropertyPathFilter(Class<?> domainType, Neo4jMappingContext neo4jMappingContext, Set<RelationshipDescription> processedRelationships) {
        PropertyFilter.RelaxedPropertyPath relaxedPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(domainType);
        ArrayList<PropertyFilter.RelaxedPropertyPath> relaxedPropertyPaths = new ArrayList<PropertyFilter.RelaxedPropertyPath>();
        relaxedPropertyPaths.add(relaxedPropertyPath);
        Neo4jPersistentEntity domainEntity = (Neo4jPersistentEntity)neo4jMappingContext.getRequiredPersistentEntity(domainType);
        domainEntity.getGraphProperties().stream().forEach(property -> relaxedPropertyPaths.add(relaxedPropertyPath.append(property.getFieldName())));
        for (RelationshipDescription relationshipDescription : domainEntity.getRelationshipsInHierarchy(any -> true)) {
            NodeDescription<?> target = relationshipDescription.getTarget();
            PropertyFilter.RelaxedPropertyPath relationshipPath = relaxedPropertyPath.append(relationshipDescription.getFieldName());
            relaxedPropertyPaths.add(relationshipPath);
            processedRelationships.add(relationshipDescription);
            PropertyFilterSupport.createRelaxedPropertyPathFilter(domainType, target, relationshipPath, relaxedPropertyPaths, processedRelationships);
        }
        return relaxedPropertyPaths;
    }

    private static Collection<PropertyFilter.RelaxedPropertyPath> createRelaxedPropertyPathFilter(Class<?> domainType, NodeDescription<?> nodeDescription, PropertyFilter.RelaxedPropertyPath relaxedPropertyPath, Collection<PropertyFilter.RelaxedPropertyPath> relaxedPropertyPaths, Set<RelationshipDescription> processedRelationships) {
        relaxedPropertyPaths.add(relaxedPropertyPath);
        if (nodeDescription.hasAggregateBoundaries(domainType)) {
            relaxedPropertyPaths.add(relaxedPropertyPath.append(((Neo4jPersistentProperty)((Neo4jPersistentEntity)nodeDescription).getRequiredIdProperty()).getFieldName()));
            return relaxedPropertyPaths;
        }
        nodeDescription.getGraphProperties().stream().forEach(property -> relaxedPropertyPaths.add(relaxedPropertyPath.append(property.getFieldName())));
        for (RelationshipDescription relationshipDescription : nodeDescription.getRelationshipsInHierarchy(any -> true)) {
            if (processedRelationships.contains(relationshipDescription)) continue;
            NodeDescription<?> target = relationshipDescription.getTarget();
            PropertyFilter.RelaxedPropertyPath relationshipPath = relaxedPropertyPath.append(relationshipDescription.getFieldName());
            relaxedPropertyPaths.add(relationshipPath);
            processedRelationships.add(relationshipDescription);
            PropertyFilterSupport.createRelaxedPropertyPathFilter(domainType, target, relationshipPath, relaxedPropertyPaths, processedRelationships);
        }
        return relaxedPropertyPaths;
    }

    private static Collection<PropertyFilter.ProjectedPath> createListForAggregate(Class<?> domainType, Neo4jMappingContext neo4jMappingContext) {
        PropertyFilter.RelaxedPropertyPath relaxedPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(domainType);
        ArrayList<PropertyFilter.ProjectedPath> filteredProperties = new ArrayList<PropertyFilter.ProjectedPath>();
        Neo4jPersistentEntity domainEntity = (Neo4jPersistentEntity)neo4jMappingContext.getRequiredPersistentEntity(domainType);
        domainEntity.getGraphProperties().stream().forEach(property -> filteredProperties.add(new PropertyFilter.ProjectedPath(relaxedPropertyPath.append(property.getFieldName()), false)));
        for (RelationshipDescription relationshipDescription : domainEntity.getRelationshipsInHierarchy(any -> true)) {
            NodeDescription<?> target = relationshipDescription.getTarget();
            filteredProperties.addAll(PropertyFilterSupport.createListForAggregate(domainType, target, relaxedPropertyPath.append(relationshipDescription.getFieldName())));
        }
        return filteredProperties;
    }

    private static Collection<PropertyFilter.ProjectedPath> createListForAggregate(Class<?> domainType, NodeDescription<?> nodeDescription, PropertyFilter.RelaxedPropertyPath relaxedPropertyPath) {
        ArrayList<PropertyFilter.ProjectedPath> filteredProperties = new ArrayList<PropertyFilter.ProjectedPath>();
        filteredProperties.add(new PropertyFilter.ProjectedPath(relaxedPropertyPath, false));
        if (nodeDescription.hasAggregateBoundaries(domainType)) {
            filteredProperties.add(new PropertyFilter.ProjectedPath(relaxedPropertyPath.append(((Neo4jPersistentProperty)((Neo4jPersistentEntity)nodeDescription).getRequiredIdProperty()).getFieldName()), false));
            return filteredProperties;
        }
        nodeDescription.getGraphProperties().stream().forEach(property -> filteredProperties.add(new PropertyFilter.ProjectedPath(relaxedPropertyPath.append(property.getFieldName()), false)));
        for (RelationshipDescription relationshipDescription : nodeDescription.getRelationshipsInHierarchy(any -> true)) {
            NodeDescription<?> target = relationshipDescription.getTarget();
            filteredProperties.addAll(PropertyFilterSupport.createListForAggregate(domainType, target, relaxedPropertyPath.append(relationshipDescription.getFieldName())));
        }
        return filteredProperties;
    }

    private static boolean containsAggregateBoundary(Class<?> domainType, Neo4jMappingContext neo4jMappingContext) {
        HashSet<RelationshipDescription> processedRelationships = new HashSet<RelationshipDescription>();
        Neo4jPersistentEntity domainEntity = (Neo4jPersistentEntity)neo4jMappingContext.getRequiredPersistentEntity(domainType);
        if (AGGREGATE_BOUNDARIES.hasEntry(domainEntity, domainType)) {
            return AGGREGATE_BOUNDARIES.getCachedStatus(domainEntity, domainType);
        }
        Iterator iterator = domainEntity.getRelationshipsInHierarchy(any -> true).iterator();
        if (iterator.hasNext()) {
            RelationshipDescription relationshipDescription = (RelationshipDescription)iterator.next();
            NodeDescription<?> target = relationshipDescription.getTarget();
            if (target.hasAggregateBoundaries(domainType)) {
                AGGREGATE_BOUNDARIES.add(domainEntity, domainType, true);
                return true;
            }
            processedRelationships.add(relationshipDescription);
            boolean containsAggregateBoundary = PropertyFilterSupport.containsAggregateBoundary(domainType, target, processedRelationships);
            AGGREGATE_BOUNDARIES.add(domainEntity, domainType, containsAggregateBoundary);
            return containsAggregateBoundary;
        }
        AGGREGATE_BOUNDARIES.add(domainEntity, domainType, false);
        return false;
    }

    private static boolean containsAggregateBoundary(Class<?> domainType, NodeDescription<?> nodeDescription, Set<RelationshipDescription> processedRelationships) {
        for (RelationshipDescription relationshipDescription : nodeDescription.getRelationshipsInHierarchy(any -> true)) {
            NodeDescription<?> target = relationshipDescription.getTarget();
            Class<?> underlyingClass = nodeDescription.getUnderlyingClass();
            if (processedRelationships.contains(relationshipDescription)) continue;
            if (target.hasAggregateBoundaries(domainType)) {
                return true;
            }
            processedRelationships.add(relationshipDescription);
            return PropertyFilterSupport.containsAggregateBoundary(domainType, target, processedRelationships);
        }
        return false;
    }

    static Collection<PropertyFilter.ProjectedPath> addPropertiesFrom(Class<?> domainType, Class<?> returnType, ProjectionFactory projectionFactory, Neo4jMappingContext neo4jMappingContext) {
        ProjectionInformation projectionInformation = projectionFactory.getProjectionInformation(returnType);
        HashSet<PropertyFilter.ProjectedPath> propertyPaths = new HashSet<PropertyFilter.ProjectedPath>();
        Neo4jPersistentEntity domainEntity = (Neo4jPersistentEntity)neo4jMappingContext.getRequiredPersistentEntity(domainType);
        for (PropertyDescriptor inputProperty : projectionInformation.getInputProperties()) {
            TypeInformation typeInformation = null;
            if (projectionInformation.isClosed()) {
                typeInformation = PropertyPath.from((String)inputProperty.getName(), returnType).getTypeInformation();
            } else {
                for (GraphPropertyDescription graphProperty : domainEntity.getGraphProperties()) {
                    if (!graphProperty.getPropertyName().equals(inputProperty.getName())) continue;
                    typeInformation = Optional.ofNullable((Neo4jPersistentProperty)domainEntity.getPersistentProperty(graphProperty.getFieldName())).map(PersistentProperty::getTypeInformation).orElse(null);
                    break;
                }
                if (typeInformation == null) {
                    for (RelationshipDescription relationshipDescription : domainEntity.getRelationships()) {
                        if (!relationshipDescription.getFieldName().equals(inputProperty.getName())) continue;
                        typeInformation = Optional.ofNullable((Neo4jPersistentProperty)domainEntity.getPersistentProperty(relationshipDescription.getFieldName())).map(PersistentProperty::getTypeInformation).orElse(null);
                        break;
                    }
                }
            }
            if (typeInformation == null) continue;
            PropertyFilterSupport.addPropertiesFrom(domainType, returnType, projectionFactory, propertyPaths, new ProjectionPathProcessor(inputProperty.getName(), typeInformation), neo4jMappingContext);
        }
        return propertyPaths;
    }

    private static void addPropertiesFrom(Class<?> domainType, Class<?> returnedType, ProjectionFactory factory, Collection<PropertyFilter.ProjectedPath> filteredProperties, ProjectionPathProcessor projectionPathProcessor, Neo4jMappingContext mappingContext) {
        ProjectionInformation projectionInformation = factory.getProjectionInformation(returnedType);
        PropertyFilter.RelaxedPropertyPath propertyPath = projectionInformation.isClosed() ? PropertyFilter.RelaxedPropertyPath.withRootType(returnedType).append(projectionPathProcessor.path) : PropertyFilter.RelaxedPropertyPath.withRootType(domainType).append(projectionPathProcessor.path);
        Class propertyType = projectionPathProcessor.typeInformation.getType();
        TypeInformation currentTypeInformation = projectionPathProcessor.typeInformation.getActualType();
        if (projectionPathProcessor.typeInformation.isMap()) {
            TypeInformation mapValueType = projectionPathProcessor.typeInformation.getRequiredMapValueType();
            if (mapValueType.isCollectionLike()) {
                currentTypeInformation = projectionPathProcessor.typeInformation.getRequiredMapValueType().getComponentType();
                propertyType = Objects.requireNonNull(currentTypeInformation, "Cannot retrieve collection type").getType();
            } else {
                currentTypeInformation = projectionPathProcessor.typeInformation.getRequiredMapValueType();
                propertyType = currentTypeInformation.getType();
            }
        } else if (projectionPathProcessor.typeInformation.isCollectionLike()) {
            currentTypeInformation = projectionPathProcessor.typeInformation.getComponentType();
            propertyType = Objects.requireNonNull(currentTypeInformation, "Cannot retrieve collection type").getType();
        }
        Objects.requireNonNull(currentTypeInformation, "Property type is required");
        if (mappingContext.getConversionService().isSimpleType(propertyType)) {
            filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, false));
        } else if (mappingContext.hasPersistentEntityFor(propertyType)) {
            filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, true));
        } else {
            ProjectionInformation nestedProjectionInformation = factory.getProjectionInformation(propertyType);
            if (nestedProjectionInformation.isClosed()) {
                filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, false));
                for (PropertyDescriptor nestedInputProperty : nestedProjectionInformation.getInputProperties()) {
                    TypeInformation typeInformation = currentTypeInformation.getRequiredProperty(nestedInputProperty.getName());
                    ProjectionPathProcessor nextProjectionPathProcessor = projectionPathProcessor.next(nestedInputProperty, typeInformation);
                    TypeInformation actualType = Objects.requireNonNull(nextProjectionPathProcessor.typeInformation.getActualType());
                    if (!projectionPathProcessor.isChildLevel() || !domainType.equals(nextProjectionPathProcessor.typeInformation.getType()) && !returnedType.equals(actualType.getType()) && !returnedType.equals(nextProjectionPathProcessor.typeInformation.getType())) {
                        if (projectionPathProcessor.typeInformation.getActualType() != null && projectionPathProcessor.typeInformation.getActualType().getType().equals(actualType.getType()) || !projectionPathProcessor.typeInformation.isCollectionLike() && !projectionPathProcessor.typeInformation.isMap() && projectionPathProcessor.typeInformation.getType().equals(nextProjectionPathProcessor.typeInformation.getType())) {
                            filteredProperties.add(new PropertyFilter.ProjectedPath(propertyPath, true));
                            continue;
                        }
                        PropertyFilterSupport.addPropertiesFrom(domainType, returnedType, factory, filteredProperties, nextProjectionPathProcessor, mappingContext);
                        continue;
                    }
                    break;
                }
            } else {
                PropertyFilter.RelaxedPropertyPath domainBasedPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(domainType).append(projectionPathProcessor.path);
                filteredProperties.add(new PropertyFilter.ProjectedPath(domainBasedPropertyPath, true));
            }
        }
    }

    private static final class ProjectionPathProcessor {
        final TypeInformation<?> typeInformation;
        final String path;
        final String name;

        private ProjectionPathProcessor(String name, String path, TypeInformation<?> typeInformation) {
            this.typeInformation = typeInformation;
            this.path = path;
            this.name = name;
        }

        private ProjectionPathProcessor(String name, TypeInformation<?> typeInformation) {
            this(name, name, typeInformation);
        }

        ProjectionPathProcessor next(PropertyDescriptor nextProperty, TypeInformation<?> nextTypeInformation) {
            String nextPropertyName = nextProperty.getName();
            return new ProjectionPathProcessor(nextPropertyName, this.path + "." + nextPropertyName, nextTypeInformation);
        }

        boolean isChildLevel() {
            return this.path.contains(".");
        }
    }

    private static final class AggregateBoundaries {
        private final Set<AggregateBoundary> aggregateBoundaries = new HashSet<AggregateBoundary>();
        private final ReentrantLock lock = new ReentrantLock();

        private AggregateBoundaries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Neo4jPersistentEntity<?> entity, Class<?> domainType, boolean status) {
            try {
                this.lock.lock();
                for (AggregateBoundary aggregateBoundary : this.aggregateBoundaries) {
                    if (!aggregateBoundary.domainType().equals(domainType) || !aggregateBoundary.entity().equals(entity) || aggregateBoundary.status() == status) continue;
                    throw new IllegalStateException("%s cannot have a different status to %s. Was %s now %s".formatted(entity.getUnderlyingClass(), domainType, aggregateBoundary.status(), status));
                }
                this.aggregateBoundaries.add(new AggregateBoundary(entity, domainType, status));
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasEntry(Neo4jPersistentEntity<?> entity, Class<?> domainType) {
            try {
                this.lock.lock();
                for (AggregateBoundary aggregateBoundary : this.aggregateBoundaries) {
                    if (!aggregateBoundary.domainType().equals(domainType) || !aggregateBoundary.entity().equals(entity)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getCachedStatus(Neo4jPersistentEntity<?> entity, Class<?> domainType) {
            try {
                this.lock.lock();
                for (AggregateBoundary aggregateBoundary : this.aggregateBoundaries) {
                    if (!aggregateBoundary.domainType().equals(domainType) || !aggregateBoundary.entity().equals(entity)) continue;
                    boolean bl = aggregateBoundary.status();
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    record AggregateBoundary(Neo4jPersistentEntity<?> entity, Class<?> domainType, boolean status) {
    }
}

